% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMOCLES_sim.R
\name{DAMOCLES_sim}
\alias{DAMOCLES_sim}
\title{Simulating DAMOCLES}
\usage{
DAMOCLES_sim(
  phy,
  gamma_0,
  gamma_td,
  mu,
  sigma,
  psiBranch,
  psiTrait,
  z,
  phi,
  traitOpt,
  br0,
  br_td,
  nTdim,
  root.state,
  root.trait.state,
  plotit = FALSE,
  keepExtinct = FALSE
)
}
\arguments{
\item{phy}{phylogeny in phylo format}

\item{gamma_0}{initial per lineage rate of immigration (gamma)}

\item{gamma_td}{time dependency in gamma}

\item{mu}{per lineage rate of local extinction}

\item{sigma}{probability of local (i.e. in-situ) speciation}

\item{psiBranch}{phylogenetic distance at which gamma is half gamma_0}

\item{psiTrait}{trait distance at which gamma is half gamma_0}

\item{z}{shape of increase in gamma with increasing trait or phylogenetic
distance}

\item{phi}{rate of decline in gamma with distance from trait optima}

\item{traitOpt}{trait value at which gamma = gamma_0}

\item{br0}{Brownian rate parameter}

\item{br_td}{rate of temporal decline in Brownian rate parameter}

\item{nTdim}{number of independent trait dimensions}

\item{root.state}{geographic state of ancestor i.e. present (1) or absent(0)}

\item{root.trait.state}{trait value of ancestor}

\item{plotit}{whether to plot the phylogeny and timing of immigration/local
extinction events}

\item{keepExtinct}{whether to retain data for extinct lineages}
}
\value{
A list of two tables. The first table contains the following
columns: The first column contains the vector of tip labels in the phylogeny
The last column contains the presence (1) or absence (0) of the species The
second table has dimensions d x N where d is the number of trait dimensions
and N is the number of species. It contains the trait values.
}
\description{
Simulates DAMOCLES
}
\examples{

#create random phylogeny
library(ape)
phy = ape::rcoal(10)
		
#run DAMOCLES		
out = DAMOCLES_sim(
  phy,
  gamma_0 = 1.5,
  gamma_td =0,
  mu = 0,
  sigma = 0,
  psiBranch = 0,
  psiTrait = 0,
  z = 10,
  phi = 0,
  traitOpt = 1,
  br0 = 0.1,
  br_td = -0.1,
  nTdim = 2,
  root.state = 1,
  root.trait.state = 0,
  plotit = FALSE,
  keepExtinct = FALSE
  )

#the output consists of a list		
patable = out[[1]] # the first element is the presence absence table
traits = out[[2]] # this is a matrix of traits values

#show presence/absence on the tree
patable$col = rep("black",dim(patable)[1])
patable$col[which(patable$state == 1)] = "red"
plot(phy,tip.col = patable$col)

}
\references{
Pigot, A.L. & R.S. Etienne (2015). A new dynamic null model for
phylogenetic community structure. Ecology Letters 18: 153-163.
}
\seealso{
\code{\link{DAMOCLES_ML}} \code{\link{DAMOCLES_loglik}}
}
\author{
Alex L. Pigot
}
\keyword{models}
