% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{stein_beta}
\alias{stein_beta}
\title{Calculate Stein's Beta for Each Cluster}
\usage{
stein_beta(data, cluster_id, beta)
}
\arguments{
\item{data}{A dataframe containing the data.}

\item{cluster_id}{The name of the column representing the cluster IDs.}

\item{beta}{The name of the column representing the beta estimates.}
}
\value{
A data frame containing the input data with additional columns:
\item{stein_beta}{The Stein-shrinkage adjusted beta values.}
\item{lambda_d}{Shrinkage factors for each cluster.}
\item{mu_beta_m}{Mean beta values for each cluster.}
\item{sigma_hat_sq}{Estimated variance of the beta values within clusters.}
\item{sum_of_squares}{Sum of squared deviations of beta values from their mean.}
}
\description{
This function calculates Stein's Beta for each cluster within the dataset.
It applies Stein's shrinkage estimator to the specified beta estimates within each cluster.
}
\examples{
# Create dummy data
library(dplyr)
set.seed(123)
dummy_data <- data.frame(
  years_education = rnorm(100, 12, 3),    # Represents years of education
  gender_female = rbinom(100, 1, 0.5),    # 1 = Female, 0 = Male
  household_wealth = sample(1:5, 100, replace = TRUE),  # Wealth index from 1 to 5
  district_code = sample(1:10, 100, replace = TRUE)     # Represents district codes
) \%>\% arrange(district_code)

# Define a regression formula
formula <- years_education ~ gender_female + household_wealth + household_wealth:gender_female

# Run the regression for all districts
results1 <- DHSr::Replm2(dummy_data, formula, "district_code", "normal")

# Assign random clusters for demonstration
clusters <- data.frame(
  district_code = unique(dummy_data$district_code),
  cluster_id = sample(1:3, length(unique(dummy_data$district_code)), replace = TRUE)
)

# Merge clusters with regression results
cluster_beta <- merge(clusters, results1, by.x = "district_code", by.y = "location")

# Apply Stein Beta shrinkage
results_with_stein_beta <- DHSr::stein_beta(
  data = cluster_beta,
  cluster_id = "cluster_id",                # Column for cluster IDs
  beta = "estimate_gender_female"          # Column for beta estimates
)

# View results
print(head(results_with_stein_beta))
}
