% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AreaEstimator.R
\name{areaEstimator}
\alias{areaEstimator}
\title{Area Estimator}
\usage{
areaEstimator(sitemap, fieldarea, precision = 1000)
}
\arguments{
\item{sitemap}{a matrix with sites per row and columns:
\code{site_number}, \code{site_area}, \code{eccentricity}, \code{angle}, \code{center.x}, \code{center.y}, \code{ellipse.a},\code{ellipse.b}}

\item{fieldarea}{vector with dimensions of field surveyed in km: \code{c(x_size,y_size)}}

\item{precision}{how many dots will be projected of field. Total dots equal \code{precision * precision}.
Default value = \code{1000} (1 million dots projected)}
}
\value{
The rate of points that are inside at least one ellipse divided by all points projected in the area.
}
\description{
Estimate the area of multiple overlapping ellipses
}
\details{
This function will estimate the area occupied by sites (ellipses) in a rectangular
field, taking into consideration the fact that sites can overlap. It is formatted to be used inside
\code{fieldMap()}.

This function is a cookie-cutter area estimator, given the complexities of
calculating the real areas of overlapping ellipses. It projects N x N equally spaced dots in the survey field
and calculates the ratio of how many of them fall inside at least one site (ellipse). Using a precision of 1000 x 1000 dots,
it approximates area to within 0.1\% of real area.
}
\examples{
 #create a matrix with 2 sites randomly located using `fieldMap()`
 site.example<-fieldMap(c(1,1),2,250000,plot=TRUE)

 #define size of field
 field.area<-c(1,1)

 #calculate area
 areaEstimator(site.example$site.frame,field.area)

}
