% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictive_modeling.R
\name{RF_predict}
\alias{RF_predict}
\title{Predictive Modeling using Random Forest Regression}
\usage{
RF_predict(
  x_train,
  y_train,
  x_test,
  lims,
  optimize = FALSE,
  n_tree = 300,
  m_try = 0.3333,
  seed = NULL,
  verbose = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{x_train}{Training features for designing the RF regressor.}

\item{y_train}{Training response for designing the RF regressor.}

\item{x_test}{Test features for which response values are to be predicted.
If \code{x_test} is not given, the function will return the trained model.}

\item{lims}{Vector providing the range of the response values for modeling.
If missing, these values are estimated from the training response.}

\item{optimize}{Flag for model tuning. If \code{TRUE}, performs a grid search for
parameters. If \code{FALSE}, uses the parameters provided. Defaults to \code{FALSE}.}

\item{n_tree}{Number of decision trees to be built in the forest. Defaults
to \code{300}. Valid only when \code{optimize = FALSE}.}

\item{m_try}{Fraction of the features to be used for building each tree.
Defaults to \code{0.3333} (or 33.33\%). Valid only when \code{optimize = FALSE}.}

\item{seed}{Seed for random number generator (for reproducible outcomes).
Defaults to \code{NULL}.}

\item{verbose}{Flag for printing the tuning progress when \code{optimize = TRUE}.
Defaults to \code{FALSE}.}

\item{parallel}{Flag for allowing parallel processing when performing grid
search \emph{i.e.}, \code{optimimze = TRUE}. Defaults to \code{FALSE}.}
}
\value{
If \code{x_test} is missing, the trained RF regressor.

If \code{x_test} is provided, the predicted values using the model.
}
\description{
This function trains a Random Forest regressor using the training data
provided and predict response for the test features. This implementation
depends on the \code{randomForest} package.
}
\note{
The response values are filtered to be bound by range in \code{lims}.
}
\examples{
set.seed(86420)
x <- matrix(rnorm(3000, 0.2, 1.2), ncol = 3);    colnames(x) <- paste0("x", 1:3)
y <- 0.3*x[, 1] + 0.1*x[, 2] - x[, 3] + rnorm(1000, 0, 0.05)

## Get the model only...
model <- RF_predict(x_train = x[1:800, ], y_train = y[1:800], n_tree = 300)

## Get predictive performance...
y_pred <- RF_predict(x_train = x[1:800, ], y_train = y[1:800], x_test = x[801:1000, ])
y_test <- y[801:1000]
print(performance(y_test, y_pred, measures = "RSQ"))

}
\keyword{decision-tree}
\keyword{ensemble-model}
\keyword{random-forest}
