% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_functions.R
\name{zscore}
\alias{zscore}
\title{Standardize matrix per column}
\usage{
zscore(X)
}
\arguments{
\item{X}{Dataframe or matrix (-alike) containing data.}
}
\value{
The standardized dataframe.
}
\description{
This function standardized each column of a dataframe or matrix (-alike) to
have \eqn{mean = 0} and \eqn{sd = 1}.
}
\examples{
X <- matrix(rnorm(100, 0.2, 0.3), nrow = 20)
X_std <- zscore(X)
print(apply(X_std, 2, mean))
print(apply(X_std, 2, sd))

}
\keyword{normalization}
\keyword{standardization}
\keyword{zscore}
