% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapes.R
\name{getShapes}
\alias{getShapes}
\title{Shape parameters for a mixture with known contributors only}
\usage{
getShapes(mixture, pars, allelecounts = NULL)
}
\arguments{
\item{mixture}{A \code{DNAmixture}.}

\item{pars}{Model parameters.}

\item{allelecounts}{This argument is possibly redundant.}
}
\value{
For each marker a matrix of shape-parameters.
}
\description{
The function is mainly for internal use. It calculates the shape
parameters, or contribution to the shape parameter, that
correspond to the known contributors in the mixture.

\emph{IMPORTANT: This is the \pkg{DNAmixturesLite} package, which is intended as a service to enable users to try \pkg{DNAmixtures} without purchasing a commercial licence for Hugin. When at all possible, we strongly recommend the use of \pkg{DNAmixtures} rather than this lite-version. See \url{https://dnamixtures.r-forge.r-project.org/} for details on both packages.}

\emph{While the lite-version seeks to provide the full functionality of \pkg{DNAmixtures}, note that computations are much less efficient and that there are some differences in available functionality. Be aware that the present documentation is copied from \pkg{DNAmixtures} and thus may not accurately describe the implementation of this lite-version.}
}
\examples{
data(MC15, MC18, USCaucasian)
mix <- DNAmixture(list(MC15, MC18), C = list(50,50), k = 3, K = c("K1", "K3", "K2"),
database = USCaucasian)
p <- mixpar(rho = list(30, 30), eta = list(30, 30), xi = list(0.08,0.08),
            phi = list(c(K2 = 0.1, K3 = 0.2, K1 = 0.7), c(K2 = 0.1, K3 = 0.2, K1 = 0.7)))
sh <- getShapes(mix, p)
sh$VWA
}
\seealso{
predict
}
\author{
Therese Graversen
}
