% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot.R
\name{dot}
\alias{dot}
\title{Render and Export DOT Graphs in R}
\usage{
dot(DOT, file = NULL, return = "auto")
}
\arguments{
\item{DOT}{This argument takes a string containing the DOT script. It is advised to use single quotation mark for the DOT string since the script often includes double quotations which can crash the function.}

\item{file}{defines the file name for exporting the graph. The acceptable file extensions are \code{"ps"} for PostScript and \code{"svg"} for SVG format (see examples below).}

\item{return}{specifies if PS or SVG script should be printed in R console. The acceptable values are \code{"auto"}, \code{"cat"}, \code{"verbatim"}, and \code{NULL}. The default value is \code{"auto"} which does not return anything unless the \code{dot()} function is called within \code{'knitr'} or \code{'rmarkdown'} packages, which require concatenated graphical script. The \code{"cat"} returns concatenated PS or SVG script, printed in multiple lines in the R console. The \code{"verbatim"} returns a single string which is assignable to an object.}
}
\value{
By default, the function only renders and loads the DOT plot in RStudio but does not return any PS or SVG script. If the \code{return} argument is specified, it returns PostScript or SVG script. Note that for assigning the script returned from \code{dot()} to an object, only \code{"verbatim"} value can be used to create a string object.
}
\description{
Graph Description Language (DOT) is a simplified and intuitive plain text graphical language. The \code{dot()} function renders the DOT markup language in R and also provides the possibility to export the graphs in PostScript and SVG (Scalable Vector Graphics) formats. In addition, it supports literate programming packages such as Knitr and R2HTML. Visit \url{http://haghish.com/dot} for downloading examples of creating algorithms and several graphs for \code{Rmarkdown} and \code{R HTML} to generate dynamic procedural graphs in dynamic documents using the \code{DOT} package.
}
\examples{
#create a simple DOT graph and load it in RStudio
dot("digraph {A -> B;}")

#to produce a dynamic document including a diagram in 'rmarkdown'
\dontrun{
```{r echo=FALSE, results='asis'}
library(DOT)
dot("digraph {A -> B;}", return = "cat")
```}


#create a DOT graph and export a SVG file to the working directory
dot("digraph {A -> B; B -> C; B -> D;}", file = "myfile.svg")

#export the example above in PostScript format
dot("digraph {A -> B; B -> C; B -> D;}", file = "myfile.ps")

#create a DOT graph and save the script in a string object in R
myString <- dot("digraph {A -> B;}", return = "verbatim")
}
\author{
E. F. Haghish \cr
Medical Informatics and Biostatistics (IMBI) \cr
University of Freiburg, Germany \cr
\email{haghish@imbi.uni-freiburg.de} \cr
\cr
Department of Mathematics and Computer Science \cr
University of Southern Denmark \cr
\email{haghish@imada.sdu.dk}
}
\keyword{diagram}
\keyword{graphics}
\keyword{literate}
\keyword{plot}
\keyword{visualization}

