% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseM.R
\name{chooseM}
\alias{chooseM}
\title{Adaptive Choice of the Bootstrap Resample Size M}
\usage{
chooseM(
  outcome,
  blip.mod,
  treat.mod,
  tf.mod,
  data = NULL,
  method = c("gest", "dwols", "qlearn"),
  treat.type = c("bin", "multi", "cont"),
  treat.fam = gaussian(link = "identity"),
  weight = c("abs", "ipw", "cipw", "qpom", "wo", "none", "manual"),
  n.bins = 3L,
  treat.wgt.man = NULL,
  treat.range = NULL,
  missing = c("drop", "ipw"),
  missing.mod = NULL,
  B1 = 500,
  B2 = 500
)
}
\arguments{
\item{outcome}{The outcome variable. Missing data will result in a stopping
error.}

\item{blip.mod}{A list of formula objects specifying covariates of the
blip function for each stage in order. No dependent variable should be 
specified. Note that this input should include the treatment variable 
ONLY if the blip model is quadratic in treatment. See Details for further 
clarification.}

\item{treat.mod}{A list of formula objects specifying the treatment model for
each stage in order. Treatment variable should be included as the dependent
variable. If treatment is binary \code{\link[stats]{glm}(family = binomial)}
will be 
used to obtain parameter estimates; if treatment is multi-nomial, 
\code{\link[nnet]{multinom}()} will be used to obtain parameter estimates; and if 
treatment is continuous, \code{\link[stats]{lm}()} will be used.}

\item{tf.mod}{A list of formula objects specifying covariates of the
treatment-free model for each stage in order. No dependent variable should 
be specified.}

\item{data}{A data frame containing all necessary covariates and treatments
contained in the models. Missing data should be coded as \code{NA}.}

\item{method}{The DTR method to be used, choose "dwols" for dynamic WOLS, 
"gest" for G-estimation, or "qlearn" for Q-learning.}

\item{treat.type}{A character object. Must be one of \{"bin", "multi", "cont"\}
indicating that the treatments at each stage are binary, multinomial,
or continuous, respectively. Each stage must have the same treatment type.}

\item{treat.fam}{A character or family object. 
The description of the dose distribution along with the link 
function to be used in the treatment model for computing weights; should be 
specified in a similar format as that used in \code{\link[stats]{glm}()}. 
If character object, must be one of \{"gaussian", "Gamma"\}, for which
\code{\link[stats]{gaussian}(link = "identity")} or 
\code{\link[stats]{Gamma}(link = "log")} 
will be used,
respectively. Input is ignored for \code{treat.type = "bin"} and 
\code{treat.type = "multi"}.}

\item{weight}{The form of the treatment weight. See details.}

\item{n.bins}{An integer object. The number of bins (levels) to be used for 
categorizing continuous doses. This input is required only when
\code{treat.type = "cont"} and \code{weight = "wo"} or \code{weight = "qpom"}.}

\item{treat.wgt.man}{NULL or a list of vectors of known treatment weights can be 
specified to be used instead of hard-coded treatment weight options.
The \eqn{i^{th}}{ith} element of the list contains the multiplicative weights 
for the \eqn{i^{th}}{ith} stage. Each vector must be of length \eqn{n}{n}, 
the number of participants. Used only for \code{method = "dwols"}.}

\item{treat.range}{For continuous treatments. Specify the maximum/minimum 
value that treatments can be take. If unspecified then the minimum/maximum 
value of observed treatments is used. If you wish to have unrestricted 
treatments set this option to \code{c(-Inf, +Inf)}. If each stage has its own
range, provide as a list, the ith element providing the min and max
for the ith stage treatment.}

\item{missing}{A character object. Must be one of \{"drop", "ipw"\}.
If set to "ipw" and covariate or treatment data are missing then inverse 
probability 
weights are used. The complete case probability is estimated 
via logistic regression. If set to "drop" and data are missing, participants
with missing data are dropped for all stage analyses.}

\item{missing.mod}{An optional list of formula objects specifying the model
for the inverse probability of weights for each stage in order.
No dependent variable should be specified. If \code{missing = "ipw"} and 
\code{missing.mod = NULL}, then the models are assumed to be linear comprising
the full covariate history derived from all of the previous stage models.}

\item{B1}{Number of first-level bootstrap resamples.}

\item{B2}{Number of second-level bootstrap resamples.}
}
\value{
A list with a single element 
  \item{m }{Resample size for using in the m-out-of-n bootstrap.}
}
\description{
Implementation of a double-bootstrap algorithm for choosing the bootstrap 
  resample size \eqn{m}{m} in a data-adaptive manner. The function returns the 
  resample size to be used to apply the m-out-of-n bootstrap with \link{DTRreg}.
}
\details{
The m-out-of-n bootstrap is an adequate tool for constructing valid 
  confidence intervals for the first stage parameters in \link{DTRreg}. The 
  resample size \eqn{m}{m} is: 
  \eqn{m = n^{\frac{1 + \alpha(1-\hat{p})}{1+\alpha}}}{%
  m = n^[1+alpha(1-pHat)/(1+alpha)]}. The estimated non-regularity level is 
  computed by \link{DTRreg}. The double-bootstrap algorithm is a cross-validation 
  tool for choosing the tuning parameter \eqn{\alpha}{alpha} in a data-driven way.
 
The current implementation is valid for a two-stage DTR. Moreover, the 
  current implementation may be unstable when there are many missing data.
}
\examples{
data(twoStageCont)

# models to be passed to DTRreg
# blip model
blip.mod <- list(~ X1, ~ X2)
# treatment model (correctly specified)
treat.mod <- list(A1 ~ X1, A2 ~ 1)
# treatment-free model (incorrectly specified)
tf.mod <- list(~ X1, ~ X2)

# perform dWOLS without calculating confidence intervals
mod1 <- DTRreg(twoStageCont$Y, blip.mod, treat.mod, tf.mod, 
               data = twoStageCont, method = "dwols")
  
# choose m adaptively for that model
\dontrun{
  m <- chooseM(twoStageCont$Y, blip.mod, treat.mod, tf.mod, 
               data = twoStageCont, method = "dwols",
               B1 = 200, B2 = 200)$m
}
m <- 94
  
# dWOLS with confidence intervals from the m-out-of-n bootstrap
mod2 <- DTRreg(twoStageCont$Y, blip.mod, treat.mod, tf.mod, 
               data = twoStageCont, method = "dwols",
               var.estim = "bootstrap", 
               bootstrap.controls = list(M = m))
}
\references{
Chakraborty, B., Moodie, E. E. M. (2013) \emph{Statistical Methods for 
  Dynamic Treatment Regimes}. New York: Springer.
  
  Efron B., Tibshirani R. J. (1994) An Introduction to the Bootstrap. 
  \emph{CRC press}.
  
  Wallace, M. P., Moodie, E. M. (2015) Doubly-Robust Dynamic Treatment 
  Regimen Estimation Via Weighted Least Squares. \emph{Biometrics} 
  \bold{71}(3), 636--644 (doi:10.1111/biom.12306.)
% Eventually update with reference to my paper
}
\author{
Gabrielle Simoneau
}
\concept{adaptive treatment strategies}
\concept{double bootstrap}
\concept{dynamic treatment regimens}
\concept{dynamic weighted ordinary least squares}
\concept{g-estimation}
\concept{m-out-of-n bootstrap}
\concept{personalized medicine}
