% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MASTSignatureMatrixGivenDE.R
\name{MASTSignatureMatrixGivenDE}
\alias{MASTSignatureMatrixGivenDE}
\title{Build Signature matrix using MAST given a differential expression
matrix}
\usage{
MASTSignatureMatrixGivenDE(
  scdata,
  id,
  path,
  diff.cutoff = 0.5,
  pval.cutoff = 0.01
)
}
\arguments{
\item{scdata}{The data}

\item{id}{The identities of the genes}

\item{path}{The path to the file results}

\item{diff.cutoff}{This is automatically set to 0.5}

\item{pval.cutoff}{This is automatically set to 0.01}
}
\value{
Signature Matrix built using the MAST algorithm
}
\description{
This function builds a signature matrix using a pre-created
differential expression matrix. The input matrix must have the same format
as the DEAnalysisMAST() function and must be saved as an RData file
ending with _MIST. The file must be named identity_MIST.RData.
See exampledata_MIST.RData for more information (inst/man).
}
\examples{

\donttest{

#dataSC
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataSC.RData"
#dest <- "data/dataSC.RData"
#load(download.file(url, tempfile(data/dataSC.RData))
#load("dataSC.RData")
#SOLUTION
load(system.file("extdata", "dataSC.RData", package = "DWLS"))

#dataBulk
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/dataBulk.RData"
#dest <- "data/dataBulk.RData"
#load(download.file(url, tempfile(dest)))
#load("data/dataBulk.RData")
load(system.file("extdata", "dataBulk.RData", package = "DWLS"))

#labels
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/labels.RData"
#dest <- "data/labels.RData"
#download.file(url, dest)
#load("data/labels.RData")
load(system.file("extdata", "labels.RData", package = "DWLS"))

#data('trueLabels', package = "DWLS")
#url <- "https://github.com/sistia01/DWLS/raw/main/inst/extdata/trueLabels.RData"
#dest <- "data/trueLabels.RData"
#download.file(url, dest)
#load("data/trueLabels.RData")
load(system.file("extdata", "trueLabels.RData", package = "DWLS"))

labels<-trueLabels

#Change to real labels
newcat<-c("NonCycISC","CycISC","TA","Ent","PreEnt","Goblet",
"Paneth","Tuft","EE")
for (i in 1:length(newcat)){
  labels[which(labels==(i-1))]<-newcat[i]
  }
#Results in inst/extdata/results -- run on local
#Signature<-buildSignatureMatrixMAST(dataSC,labels,"results",
# diff.cutoff=0.5,pval.cutoff=0.01)
}

}
