% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DWNARDL.R
\name{DWNARDL}
\alias{DWNARDL}
\title{Wavelet-based NARDL Model}
\usage{
DWNARDL(ts, Filter = "haar", Wvlevels = NULL, Exo, MaxLag = 3, Trend = TRUE)
}
\arguments{
\item{ts}{A time series object (numeric vector) for the dependent variable.}

\item{Filter}{Wavelet filter to use (default is "haar").}

\item{Wvlevels}{Number of wavelet decomposition levels. Default is calculated based on the length of `ts`.}

\item{Exo}{A time series object (numeric vector) for the exogenous variable.}

\item{MaxLag}{Maximum number of lags to consider. Default is 3.}

\item{Trend}{Boolean to include trend in the model. Default is TRUE.}
}
\value{
A list containing:
\item{Coefficients}{Model coefficients (short and long run).}
\item{AsymTest}{Wald test statistics and p-values.}
\item{IC}{Information criteria (AIC, BIC, Log-likelihood).}
}
\description{
This function implements the Wavelet-based Nonlinear Autoregressive Distributed Lag (WNARDL) model using wavelet transform.
}
\examples{
ts <- rnorm(100)
Exo <- rnorm(100)
Results <- DWNARDL(ts, Filter = "haar", Exo = Exo, MaxLag = 3)
}
\references{
Jammazi, R., Lahiani, A., & Nguyen, D. K. (2015). A wavelet-based nonlinear ARDL model for assessing the exchange rate pass-through to crude oil prices. *Journal of International Financial Markets, Institutions and Money, 34*, 173-187. https://doi.org/10.1016/j.intfin.2014.11.011
}
