% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fractional_table.R
\name{Fractional_table}
\alias{Fractional_table}
\title{Fractional table of mortality}
\usage{
Fractional_table(data, frac, i = 0.04, assumption = "UDD")
}
\arguments{
\item{data}{A data.frame of the annual mortality table, with the first column being the age and the second one the probability of death.}

\item{frac}{An integer. The number of fractions per year.}

\item{i}{A numeric type value. The interest rate.}

\item{assumption}{A character string. The assumption used for fractional ages ("UDD" for uniform distribution of deaths and "constant" for constant force of mortality).}
}
\value{
Returns a data.frame object containing fractional age and death probability vectors.
}
\description{
Creates a fractional mortality table for a given mortality table.
}
\examples{
Fractional_table(CSO80MANB,2,0.04,"constant")
Fractional_table(CSO80MANB,2,0.04,"UDD")

}
\references{
Chapter 3 of  Actuarial Mathematics (1997) by Bowers, Gerber, Hickman, Jones & Nesbitt
}
\keyword{Fractional}
\keyword{Mortality.}
\keyword{Table}
\keyword{of}
