% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{int}
\alias{int}
\alias{int_cir}
\alias{int_sph}
\alias{int_hypsph}
\title{Integration routines}
\usage{
int_cir(f, N = 500, na.rm = TRUE, f_vect = TRUE, ...)

int_sph(f, na.rm = TRUE, f_vect = TRUE, ...)

int_hypsph(f, q, M = 1e+05, na.rm = TRUE, f_vect = TRUE, ...)
}
\arguments{
\item{f}{function to be integrated on \eqn{S^q}. Must be vectorized and
accept matrix inputs of size \code{c(nx, q + 1)}.}

\item{N}{Defaults to \code{5e2}.}

\item{na.rm}{ignore possible \code{NA}s arising from the evaluation of
\code{f}? Defaults to \code{TRUE}.}

\item{f_vect}{can \code{f} be called in a vectorized form, with matrix
input? Defaults to \code{TRUE}.}

\item{...}{further arguments passed to \code{f}.}

\item{q}{dimension of \eqn{S^q}, \eqn{q\ge 1}.}

\item{M}{number of Monte Carlo replicates. Defaults to \code{1e5}.}
}
\value{
A scalar approximating the integral.
}
\description{
Several quadrature rules for integration of functions on
\eqn{S^1}, \eqn{S^2}, and \eqn{S^q}, \eqn{q \ge 3}.
}
\details{
\code{int_cir} is an extension of equation (4.1.11) in Press et al. (1997),
a periodic trapezoidal rule. \code{int_sph} employs the
\link[=lebedev]{Lebedev quadrature} on \eqn{S^2}. \code{int_hypsph}
implements a Monte Carlo integration on \eqn{S^q}.
}
\examples{
# S^1, trapezoidal rule
f <- function(x) rotasym::d_vMF(x = x, mu = c(0, 1), kappa = 2)
int_cir(f = f)

# S^2, Lebedev rule
f <- function(x) rotasym::d_vMF(x = x, mu = c(0, 0, 1), kappa = 2)
int_sph(f = f)

# S^2, Monte Carlo
f <- function(x) rotasym::d_vMF(x = x, mu = c(0, 0, 1), kappa = 2)
int_hypsph(f = f, q = 2)
}
\references{
Lebedev, V. I. and Laikov, D. N. (1999). A quadrature formula for the
sphere of the 131st algebraic order of accuracy. \emph{Doklady Mathematics},
59(3):477--481.

Press, W. H., Teukolsky, S. A., Vetterling, W. T. and Flannery B. P. (1997).
\emph{Numerical Recipes in Fortran 77: The Art of Scientific Computing}.
Volume 1. Cambridge University Press, Cambridge. Second edition.
}
