\name{covclx}
\alias{covclx}
\title{Two-Sample Covariance Test for High-Dimensional Data}
\description{
  Performs a test to compare the covariance matrices of two high-dimensional samples.
  This test is designed for situations where the number of variables \( p \) is large relative to the sample sizes \( n_1 \) and \( n_2 \).
}
\usage{
covclx(X, Y)
}
\arguments{
  \item{X}{A numeric matrix representing the first sample, where rows are observations and columns are variables.}
  \item{Y}{A numeric matrix representing the second sample, where rows are observations and columns are variables.}
}
\details{
  This function tests the null hypothesis that the covariance matrices of two samples are equal:
  \deqn{H_0: \Sigma_1 = \Sigma_2}
  against the alternative hypothesis that they are not equal.
  
  The test statistic is based on the maximum normalized squared difference between the two sample covariance matrices.
  The p-value is computed using an extreme value distribution.
}
\value{
  A list containing the following components:
  \item{stat}{The test statistic.}
  \item{pval}{The p-value of the test.}
}
\examples{
  # Example usage:
  set.seed(123)
  n1 <- 20
  n2 <- 30
  p <- 50
  X <- matrix(rnorm(n1 * p), nrow = n1, ncol = p)
  Y <- matrix(rnorm(n2 * p), nrow = n2, ncol = p)
  result <- covclx(X, Y)
  print(result)
}
\seealso{
  \code{\link{cov}}: Used for calculating sample covariance matrices.
}
