% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateTableD2.R
\name{CreateTableD2}
\alias{CreateTableD2}
\title{Compare Two Binary Diagnostic Tests in Clinical Studies}
\usage{
CreateTableD2(x, my.printlayout = TRUE)
}
\arguments{
\item{x}{A data frame containing the diagnostic test outcomes and the true disease status.}

\item{my.printlayout}{Logical; if TRUE, prints the result table to the console and possibly saves it to a file.}
}
\value{
A list containing three data frames: `Diseased`, `Non-diseased`, and `Comparison`.
- `Diseased`: A data frame showing the contingency table for diseased cases based on the two diagnostic tests.
  It contains the counts of true positives, false negatives, false positives, and true negatives for the first diagnostic test compared to the second.
- `Non-diseased`: A data frame showing the contingency table for non-diseased cases based on the two diagnostic tests.
  Similar to `Diseased`, it contains counts of true negatives, false positives, false negatives, and true positives.
- `Comparison`: A data frame summarizing the diagnostic performance metrics (sensitivity, specificity, accuracy, PPV, NPV, and AUC) for each modality, along with the p-values from statistical tests comparing the two modalities.
  Each row represents a different metric, with columns for the estimated value of the first modality, the estimated value of the second modality, and the p-value assessing the difference between the two.
This structure allows for a comprehensive overview of the comparative diagnostic performance of the two tests, facilitating easy interpretation and analysis.
}
\description{
This function compares the diagnostic performance between two modalities on the same subject within clinical studies. It generates formatted tables displaying diagnostic outcomes for sensitivity, specificity, accuracy, positive predictive value (PPV), negative predictive value (NPV), and area under the curve (AUC), providing a clear and comprehensive comparison directly through the R console.
}
\examples{
# Assuming that data1, data2, data3, and data4 are available
# and contain columns `y1`, `y2`, and `d`
# where `y1` and `y2` are the outcomes of the two diagnostic tests,
# and `d` is the true disease status.
\donttest{
data(data1)
data(data2)
data(data3)
data(data4)

# Checking the structure of one of the datasets
str(data1)

# Creating tables using CreateTableD2 function for each dataset
CreateTableD2(data1)
CreateTableD2(data2)
CreateTableD2(data3)
CreateTableD2(data4)
}
}
