% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_pattern_long_surv.R
\name{estimate_pattern_long_surv}
\alias{estimate_pattern_long_surv}
\title{Estimate the Pattern of Longitudinal and Survival Data}
\usage{
estimate_pattern_long_surv(
  data_array,
  time_matrix,
  nobs,
  starttime,
  survtime,
  survevent,
  design_interval,
  n_time_units,
  time_unit,
  estimation_method = "risk",
  smoothing_method = "local linear",
  bw_beta,
  bw_mean,
  bw_var
)
}
\arguments{
\item{data_array}{observed data arranged in a 3d array format. \cr
\code{data_array[i,j,k]} is the jth observation of the kth dimension of the ith subject.}

\item{time_matrix}{observation times arranged in a numeric matrix format. \cr
\code{time_matrix[i,j]} is the jth observation time of the ith subject. \cr
\code{data_array[i,j,]} is observed at \code{time_matrix[i,j]}.}

\item{nobs}{number of observations arranged as an integer vector. \cr
\code{nobs[i]} is the number of observations for the ith subject.}

\item{starttime}{a vector of entry times \cr
\code{starttime[i]} is the entry time of the ith subject.}

\item{survtime}{a vector of survival times \cr
\code{survtime[i]} is the survival time of the ith subject.}

\item{survevent}{a logical vector of survival events \cr
If \code{survevents[i]==TRUE}, then a survival event is observed at \code{survtime[i]}. \cr
If \code{survevents[i]==FALSE}, then no survival event is observed at \code{survtime[i]}.}

\item{design_interval}{a numeric vector of length two that 
gives the left- and right- limits of the design interval. 
By default, \code{design_interval=range(time_matrix,na.rm=TRUE)}.}

\item{n_time_units}{an integer value that gives the number of basic time units
in the design time interval. \cr
The design interval will be discretized to \code{seq(design_interval[1],design_interval[2],length.out=n_time_units)}}

\item{time_unit}{an optional numeric value of basic time unit. Only used when \code{n_time_units} is missing.\cr
The design interval will be discretized to \code{seq(design_interval[1],design_interval[2],by=time_unit)}}

\item{estimation_method}{a string. \cr
If \code{estimation_method="risk"}, apply the risk monitoring method (c.f., You and Qiu 2020). \cr
(Currently only the method "risk" is available.)}

\item{smoothing_method}{a string. \cr
If \code{smoothing_method="local constant"}, apply local constant smoothing \cr
If \code{smoothing_method="local linear"}, apply local linear smoothing \cr}

\item{bw_beta}{an integer value. \cr
The bandwidth parameter for estimating the regression coefficients beta in the Cox model.}

\item{bw_mean}{an integer value. \cr
The bandwidth parameter for estimating mean function.}

\item{bw_var}{an integer value. \cr
The bandwidth parameter for estimating variance function.}
}
\value{
an object that stores the estimated longitudinal pattern and model parameters. \cr
If \code{estimation_method="risk"}, returns an object of class \code{pattern_long_surv_risk}. \cr
\item{$grid}{discretized design interval.}
\item{$beta_est}{Estimated regression coefficients.}
\item{$mean_risk_est}{Estimated mean function.}
\item{$var_risk_est}{Estimated variance function.}
}
\description{
Function \code{estimate_pattern_long_surv} estimate the pattern of longitudinal and survival 
data from a dataset of n subjects. This is usually the first step of dynamic screening.
The risk of a subject to event is quantified by a linear combination of longitudinal data by a Cox model.
The risk pattern can be described by mean and variance depending on the estimation method. 
When the estimated pattern is used for monitoring new subjects, the collected data from new subjects are 
compared to the estimated pattern for monitoring abnormality.
}
\details{
Estimate the Pattern of Longitudinal and Survival Data
}
\examples{
data("data_example_long_surv")

result_pattern<-estimate_pattern_long_surv(
  data_array=data_example_long_surv$data_array_IC,
  time_matrix=data_example_long_surv$time_matrix_IC,
  nobs=data_example_long_surv$nobs_IC,
  starttime=data_example_long_surv$starttime_IC,
  survtime=data_example_long_surv$survtime_IC,
  survevent=data_example_long_surv$survevent_IC,
  design_interval=data_example_long_surv$design_interval,
  n_time_units=data_example_long_surv$n_time_units,
  estimation_method="risk",
  smoothing_method="local linear",
  bw_beta=0.05,
  bw_mean=0.1,
  bw_var=0.1)
}
\references{
You, L. and Qiu, P. (2020). An effective method for online disease risk monitoring. Technometrics, 62(2):249-264.
}
