% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addendum_search_CL.R
\name{search_CL}
\alias{search_CL}
\title{Search Control Limit}
\usage{
search_CL(
  chart_matrix,
  time_matrix,
  nobs,
  starttime,
  endtime,
  design_interval,
  n_time_units,
  time_unit,
  ATS_nominal,
  CL_lower,
  CL_step,
  CL_upper,
  no_signal_action = "omit",
  ATS_tol,
  CL_tol
)
}
\arguments{
\item{chart_matrix}{charting statistics arranged as a numeric matrix. \cr
\code{chart_matrix[i,j]} is the jth charting statistic of the ith subject.}

\item{time_matrix}{observation times arranged as a numeric matrix. \cr
\code{time_matrix[i,j]} is the jth observation time of the ith subject,
corresponding to the time the charting statistic \code{chart_matrix[i,j]} is computed.}

\item{nobs}{number of observations arranged as an integer vector. \cr
\code{nobs[i]} is the number of observations for the ith subject.}

\item{starttime}{a vector of times from the start of monitoring. \cr
\code{starttime[i]} is the time that the ith subject starts to be monitored.}

\item{endtime}{a vector of times from the start of monitoring. \cr
\code{endtime[i]} is the time that the ith subject is lost to be monitored.}

\item{design_interval}{a numeric vector of length two that 
gives the left- and right- limits of the design interval. 
By default, \code{design_interval=range(time_matrix,na.rm=TRUE)}.}

\item{n_time_units}{an integer value that gives the number of basic time units
in the design time interval. \cr
The design interval will be discretized to \cr
\code{seq(design_interval[1],design_interval[2],length.out=n_time_units)}}

\item{time_unit}{an optional numeric value of basic time unit. Only used when \code{n_time_units} is missing.\cr
The design interval will be discretized to \cr
\code{seq(design_interval[1],design_interval[2],by=time_unit)}}

\item{ATS_nominal}{a numeric value. \cr
\code{ATS_nominal} is the nominal (or say targeted) ATS that is intended to achieve.}

\item{CL_lower, CL_step, CL_upper}{three numeric values. \cr
The control limit will be searched within the interval [\code{CL_lower},\code{CL_upper}]. \cr
When applying grid search, the algorithm will use a step size of \code{CL_step}. \cr
(Namely, the algorithm will start with \code{CL_lower}, 
and search through the sequences \code{CL_lower}, \code{CL_lower+CL_step}, \code{CL_lower+2*CL_step}, ... until \code{CL_upper}.)}

\item{no_signal_action}{a character specifying the method to use when a signal is not given to a process.
If \code{no_signal_action="omit"} take averages by omitting the processes with no signals, namely, average only the processes with signals. \cr
If \code{no_signal_action="maxtime"} impute the signal times by the maximum time, which is the right limit of design time interval. \cr
If \code{no_signal_action="endtime"} impute the signal times by the end times.}

\item{ATS_tol}{a numeric value. \cr
Error tolerance for ATS.}

\item{CL_tol}{a numeric value. \cr
Error tolerance for control limit.}
}
\value{
a numeric value, the control limit that gives the desired ATS.
}
\description{
Given a chart matrix, the function \code{search_CL} searches the control limit (CL)
so that the specified average time to signals (ATS) can be attained.
}
\details{
Search Control Limit
}
\examples{

result_pattern<-estimate_pattern_long_1d(
  data_matrix=data_example_long_1d$data_matrix_IC,
  time_matrix=data_example_long_1d$time_matrix_IC,
  nobs=data_example_long_1d$nobs_IC,
  design_interval=data_example_long_1d$design_interval,
  n_time_units=data_example_long_1d$n_time_units,
  estimation_method="meanvar",
  smoothing_method="local linear",
  bw_mean=0.1,
  bw_var=0.1)

result_monitoring<-monitor_long_1d(
  data_matrix_new=data_example_long_1d$data_matrix_IC,
  time_matrix_new=data_example_long_1d$time_matrix_IC,
  nobs_new=data_example_long_1d$nobs_IC,
  pattern=result_pattern,
  side="upward",
  chart="CUSUM",
  method="standard",
  parameter=0.5)

CL<-search_CL(
  chart_matrix=result_monitoring$chart,
  time_matrix=data_example_long_1d$time_matrix_IC,
  nobs=data_example_long_1d$nobs_IC,
  starttime=rep(0,nrow(data_example_long_1d$time_matrix_IC)),
  endtime=rep(1,nrow(data_example_long_1d$time_matrix_IC)),
  design_interval=data_example_long_1d$design_interval,
  n_time_units=data_example_long_1d$n_time_units,
  ATS_nominal=200,CL_lower=0,CL_upper=5)

}
