% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prognosis.R
\name{rsf_pro}
\alias{rsf_pro}
\title{Train a Random Survival Forest Model}
\usage{
rsf_pro(X, y_surv, tune = FALSE)
}
\arguments{
\item{X}{A data frame of features.}

\item{y_surv}{A \code{survival::Surv} object representing the survival outcome.}

\item{tune}{Logical, whether to perform hyperparameter tuning (a simplified
message is currently provided, full tuning with \code{tune.rfsrc} is recommended
for advanced use).}
}
\value{
A list of class "train" containing the trained \code{rfsrc} model object,
names of features used in training, and model type. The returned object
also includes \code{fitted_scores} and \code{y_surv}.
}
\description{
Trains a Random Survival Forest (RSF) model using \code{randomForestSRC}.
}
\examples{
\donttest{
# Generate some dummy survival data
set.seed(42)
n_samples <- 50
n_features <- 5
X_data <- as.data.frame(matrix(rnorm(n_samples * n_features), ncol = n_features))
Y_surv_obj <- survival::Surv(
  time = runif(n_samples, 100, 1000),
  event = sample(0:1, n_samples, replace = TRUE)
)

# Train the model (ntree is small for a quick example)
rsf_model <- rsf_pro(X_data, Y_surv_obj)
print(rsf_model$finalModel)
}
}
