% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genTEFI.R
\name{genTEFI}
\alias{genTEFI}
\title{Generalized Total Entropy Fit Index using Von Neumman's entropy (Quantum Information Theory) for correlation matrices}
\usage{
genTEFI(data, structure = NULL, verbose = TRUE)
}
\arguments{
\item{data}{Matrix, data frame, or \code{\link[EGAnet]{hierEGA}} object.
Can be raw data or correlation matrix}

\item{structure}{List (length = levels).
A list containing the hierarchical structure.
Each list element corresponds to increasing levels (1 = first level, 2 = second level, etc.).
The length of the first element (first level) should be the same as the number of variables
in \code{data}. Each level after should either be the number of variables (\code{ncol(data)}) or
the maximum number of dimensions from the preceding level (\code{max(previous_dimensions)})}

\item{verbose}{Boolean (length = 1).
Whether messages and (insignificant) warnings should be output.
Defaults to \code{TRUE} to see all messages and warnings for every
function call.
Set to \code{FALSE} to ignore messages and warnings}
}
\value{
Returns a \code{levels + 1} columns data frame of the Generalized Total Entropy
Fit Index using Von Neumman's entropy (\code{VN.Entropy.Fit}) (first column) as well as
each individual's levels entropy
}
\description{
Computes the fit (Generalized TEFI) of a hierarchical or correlated bifactor
dimensionality structure (or \code{\link{hierEGA}} objects) using Von Neumman's entropy
when the input is a correlation matrix. Lower values suggest better fit of a structure to the data
}
\examples{
# Example using network scores
opt.hier <- hierEGA(
  data = optimism, scores = "network",
  plot.EGA = FALSE # No plot for CRAN checks
)

# Compute the Generalized Total Entropy Fit Index
genTEFI(opt.hier)

}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
