% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogicRegr.R
\name{LogicRegr}
\alias{LogicRegr}
\title{A wrapper for running the Bayesian logic regression based inference
in a easy to use way}
\usage{
LogicRegr(
  formula,
  data,
  family = "Gaussian",
  prior = "J",
  report.level = 0.5,
  d = 20,
  cmax = 5,
  kmax = 20,
  p.and = 0.9,
  p.not = 0.05,
  p.surv = 0.1,
  ncores = -1,
  n.mods = 1000,
  print.freq = 1000L,
  advanced = list(presearch = TRUE, locstop = FALSE, estimator =
    estimate.logic.bern.tCCH, estimator.args = list(data = data.example, n = 1000, m =
    50, r = 1), recalc_margin = 250, save.beta = FALSE, interact = TRUE, relations =
    c("", "lgx2", "cos", "sigmoid", "tanh", "atan", "erf"), relations.prob = c(0.4, 0, 0,
    0, 0, 0, 0), interact.param = list(allow_offsprings = 1, mutation_rate = 300,
    last.mutation = 5000, max.tree.size = 1, Nvars.max = 100, p.allow.replace = 0.9,
    p.allow.tree = 0.2, p.nor = 0.2, p.and = 1), 
     n.models = 10000, unique = TRUE,
    max.cpu = ncores, max.cpu.glob = ncores, create.table = FALSE, create.hash = TRUE,
    pseudo.paral = TRUE, burn.in = 50, outgraphs = FALSE, print.freq = print.freq,
    advanced.param = list(max.N.glob = as.integer(10), min.N.glob = as.integer(5), max.N
    = as.integer(3), min.N = as.integer(1), printable = FALSE))
)
}
\arguments{
\item{formula}{a formula object for the model to be addressed}

\item{data}{a data frame object containing variables and observations
corresponding to the formula used}

\item{family}{a string taking values of either "Gaussian" or "Bernoulli"
corresponding to the linear or logistic Bayesian logic regression contexts}

\item{prior}{character values "J" or "G" corresponding either to Jeffey's
or robust g prior}

\item{report.level}{a numeric value in (0,1) specifying the threshold for
detections based on the marginal inclusion probabilities}

\item{d}{population size for the GMJMCMC algorithm}

\item{cmax}{the maximal allowed depth of logical expressions to be considered}

\item{kmax}{the maximal number of logical expressions per model}

\item{p.and}{probability of AND parameter of GMJMCMC algorithm}

\item{p.not}{probability of applying logical NOT in GMJMCMC algorithm}

\item{p.surv}{minimal survival probabilities for the features to be allowed to enter the next population}

\item{ncores}{the maximal number of cores (and GMJMCMC threads) to be
addressed in the analysis}

\item{n.mods}{the number of the best models in the thread to calculate
marginal inclusion probabilities}

\item{print.freq}{printing frequency of the intermediate results}

\item{advanced}{should only be addressed by experienced users to tune advanced
parameters of GMJMCMC, advanced corresponds to the vector of tuning
parameters of runemjmcmc function}
}
\value{
a list of
\describe{
 \item{feat.stat}{detected logical expressions and their marginal inclusion
   probabilities}
 \item{predictions}{NULL currently, since LogrRegr function is not designed
   for predictions at the moment, which is still possible in its expert
   mother function pinferunemjmcmc}
 \item{allposteriors}{all visited by GMJMCMC logical expressions and their
   marginal inclusion probabilities}
 \item{threads.stats}{a vector of detailed outputs of individual ncores
   threads of GMJMCMC run}
}
}
\description{
A wrapper for running the Bayesian logic regression based
inference in a easy to use way
}
\examples{
set.seed(040590)
X1 <- as.data.frame(
  array(
    data = rbinom(n = 50 * 1000, size = 1,
    prob = runif(n = 50 * 1000, 0, 1)), dim = c(1000, 50)
  )
)
Y1 <- rnorm(
  n = 1000,
  mean = 1 + 0.7 * (X1$V1 * X1$V4) + 0.8896846 * (X1$V8 * X1$V11) + 1.434573 * (X1$V5 * X1$V9),
  sd = 1
)
X1$Y1 <- Y1

# specify the initial formula
formula1 <- as.formula(
  paste(colnames(X1)[51], "~ 1 +", paste0(colnames(X1)[-c(51)], collapse = "+"))
)
data.example <- as.data.frame(X1)


# run the inference with robust g prior
n_cores <- 1L

\donttest{
  res4G <- LogicRegr(
    formula = formula1, data = data.example, family = "Gaussian", prior = "G",
    report.level = 0.5, d = 15, cmax = 2, kmax = 15, p.and = 0.9, p.not = 0.01,
    p.surv = 0.2, ncores = n_cores
  )
  print(res4G$feat.stat)

  # run the inference with Jeffrey's prior
  res4J <- LogicRegr(
    formula = formula1, data = data.example, family = "Gaussian", prior = "J",
    report.level = 0.5, d = 15, cmax = 2, kmax = 15, p.and = 0.9, p.not = 0.01,
    p.surv = 0.2, ncores = n_cores
  )
  print(res4J$feat.stat)
}
}
\seealso{
runemjmcmc pinferunemjmcmc
}
\keyword{methods}
\keyword{models}
