% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.parameters.R
\name{test.parameters}
\alias{test.parameters}
\title{Evaluate influence of model parameters.}
\usage{
test.parameters(
  X,
  q,
  l = 0,
  c = 100,
  rotation = "Varimax",
  plot = FALSE,
  legend,
  multicore = FALSE,
  ...
)
}
\arguments{
\item{X}{\code{Numeric} matrix, input data set with m samples (rows) 
and n variables (columns).}

\item{q}{\code{Numeric} vector, numbers of end-members to be modelled,
e.g., \code{2:10}.}

\item{l}{\code{Numeric} vector specifying the weight tranformation limit, 
i.e. quantile; default is 0.}

\item{c}{\code{Numeric} scalar specifying the constant sum scaling 
parameter, e.g., 1, 100, 1000; default is 0.}

\item{rotation}{\code{Character} scalar, rotation type, default is 
\code{"Varimax"}.}

\item{plot}{\code{Character} scalar, optional graphical output of the 
results as keyword (see details). All plots except "ol" are colour-coded 
bitmaps of q, l and the specified test parameter and line-plots the 
specified parameter vs. \code{q}.}

\item{legend}{\code{Character} scalar, specifying legend position (cf.
\code{legend}).  If omitted, no legend will be plotted, default is no
legend.}

\item{multicore}{\code{Logical} scalar, optionally ditribute calculations 
to all available cores of the computer, default is \code{TRUE}.}

\item{\dots}{Additional arguments passed to the plot function (see details).}
}
\value{
\code{List} with result objects \item{mEm}{Absolute row-wise model
error.} \item{mEn}{Absolute column-wise model error.} \item{mRm}{Mean
row-wise explained variance.} \item{mRn}{Mean column-wise explained
variance.} \item{mRt}{Mean total explained variance.} \item{ol}{Number of
overlapping end-member loadings.} \item{q.max}{Maximum number of meaningful
end-members.}
}
\description{
All possible combinations of number of end-members and weight transformation
limits are used to perform EMMA and evaluate the absolute and relative 
measures of individual model performance.
}
\details{
The mean total explained variance mRt may be used to define a maximum number
of meaningful end-members for subsequent modelling, e.g. as the number of
end-members, which reaches the first local mRt maximum.\cr Overlapping is
defined as one end-member having its mode within the "area" of any other
end-member, which is genetically not explainable.\cr Keywords to specify, 
which tested parameter will be plotted: "mEm" (mean absolute row-wise 
error), "mEn" (mean absolute column-wise error), "mRm" (mean
relative row-wise error), "mRn" (mean relative column-wise error), "mRt"
(mean relative total error) and "ol" (number of overlapping end-members).\cr
Since the function returns two plots (except for option "ol"), additional
graphical parameters must be specified as vector with the first element for
the first plot and the second element for the second plot. If graphical
parameters are natively vectors (e.g. a sequence of colours), they must be
specified as matrices with each vector as a row. A legend can only be added
to the second plot. Colours only apply to the second plot as well. If
colours are specified, \code{colour} should be used instead of \code{col}.
See example section for further advice.
}
\examples{

## load example data set
data(example_X)

## truncate the data set for faster computation
X.trunc <- X[1:20,]

## define test parameters
q <- 2:8 # number of end-members
l <- seq(from = 0, to = 0.3, by = 0.1)

## test parameter influence and plot mean total explained variance
TP <- test.parameters(X = X.trunc, q = q, l = l, plot = "mRt",
                      legend = "bottomright", cex = 0.7,
                      multicore = FALSE,
                      colour = rgb((1:7) / 7, 0.9, 0.2, 1))

## show maximum number of end-members
TP$q.max

}
\references{
Dietze E, Hartmann K, Diekmann B, IJmker J, Lehmkuhl F, Opitz S,
Stauch G, Wuennemann B, Borchers A. 2012. An end-member algorithm for
deciphering modern detrital processes from lake sediments of Lake Donggi
Cona, NE Tibetan Plateau, China. Sedimentary Geology 243-244: 169-180.
}
\seealso{
\code{EMMA}
}
\author{
Michael Dietze, Elisabeth Dietze
}
\keyword{EMMA}
