% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QRN.R
\name{QRN_fit_multiple}
\alias{QRN_fit_multiple}
\title{Wrapper for fitting a recurrent QRN with restart for stability}
\usage{
QRN_fit_multiple(
  X,
  y,
  q_level,
  number_fits = 3,
  ...,
  seed = NULL,
  data_type = c("seq", "iid")
)
}
\arguments{
\item{X}{Matrix of covariates, for training.}

\item{y}{Response variable vector to model the conditional quantile of, for training.}

\item{q_level}{Probability level of the desired conditional quantiles to predict.}

\item{number_fits}{Number of restarts.}

\item{...}{Other parameters given to \code{\link[=QRN_seq_fit]{QRN_seq_fit()}}.}

\item{seed}{Integer random seed for reproducibility in network weight initialization.}

\item{data_type}{Type of data dependence, must be one of \code{"iid"} (for iid observations) or \code{"seq"} (for sequentially dependent observations).
For the moment, only \code{"seq"} is accepted.}
}
\value{
An QRN object of classes \code{c("QRN_seq", "QRN")}, containing the fitted network,
as well as all the relevant information for its usage in other functions.
}
\description{
Wrapper for fitting a recurrent QRN with restart for stability
}
