% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QRN.R
\name{quantile_loss_tensor}
\alias{quantile_loss_tensor}
\title{Tensor quantile loss function for training a QRN network}
\usage{
quantile_loss_tensor(
  out,
  y,
  q = 0.5,
  return_agg = c("mean", "sum", "vector", "nanmean", "nansum")
)
}
\arguments{
\item{out}{Batch tensor of the quantile output by the network.}

\item{y}{Batch tensor of corresponding response variable.}

\item{q}{Probability level of the predicted quantile}

\item{return_agg}{The return aggregation of the computed loss over the batch. Must be one of \verb{"mean", "sum", "vector", "nanmean", "nansum"}.}
}
\value{
The quantile loss over the batch between the network output ans the observed responses as a \code{torch::Tensor},
whose dimensions depend on \code{return_agg}.
}
\description{
Tensor quantile loss function for training a QRN network
}
