% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_auxiliaryFunctions.R
\name{derivative.rho}
\alias{derivative.rho}
\title{Computing \eqn{\rho} and its \eqn{k}-th derivative}
\usage{
derivative.rho(grid, a, d, k, derivatives.g)
}
\arguments{
\item{grid}{a grid of numeric values}

\item{a}{a parameter \eqn{a > 0} that reduces the bias of the estimator around zero}

\item{d}{the dimension of the data}

\item{k}{the order of derivative of \eqn{\rho}.
If \code{k = 0}, then the original function value is returned.
If \code{k > 0}, the value of its derivative is returned}

\item{derivatives.g}{a matrix of size \code{length(x) * (k + 1)}
whose entry of position \code{[i,j]} is \eqn{g^{(j - 1)} (x[i])}}
}
\value{
a numeric vector \eqn{\rho(grid[1])^{(k)}, \dots, \rho(grid[N])^{(k)}},
where \eqn{N} is the length of the grid
}
\description{
The function \eqn{\rho} is used to compute \eqn{\widetilde{AMSE}}.
The quantity \eqn{\widetilde{AMSE}} is of interest
because we can use it to find the optimal \eqn{a}.
}
\examples{

# Return the 5-th derivative of tau at x = 1

grid = c(1)
a = 1; d = 3; k = 3
der.g = matrix(seq(1, 3, length.out = 4), nrow = 1)
derivative.rho(grid = grid, a = a, d = d, k = k, derivatives.g = der.g)

}
\references{
Ryan, V., & Derumigny, A. (2024).
On the choice of the two tuning parameters for nonparametric estimation of an
elliptical distribution generator
\href{https://arxiv.org/abs/2408.17087}{arxiv:2408.17087}.
}
\seealso{
\code{\link{derivative.tau}} and \code{\link{derivative.psi}}.
\code{EllDistrDerivEst} for the nonparametric estimation of the derivatives
of \code{g}, the elliptical distribution density generator.
\code{\link{compute_matrix_alpha}} which is used for the computation
of the derivatives.
}
\author{
Victor Ryan, Alexis Derumigny
}
\keyword{internal}
