% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{print.dist_spec}
\alias{print.dist_spec}
\title{Prints the parameters of one or more delay distributions}
\usage{
\method{print}{dist_spec}(x, ...)
}
\arguments{
\item{x}{The \verb{<dist_spec>} to use}

\item{...}{Not used}
}
\value{
invisible
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This displays the parameters of the uncertain and probability mass
functions of fixed delay distributions combined in the passed <dist_spec>.
}
\examples{
#' # A fixed lognormal distribution with mean 5 and sd 1.
dist1 <- LogNormal(mean = 1.5, sd = 0.5, max = 20)
print(dist1)

# An uncertain gamma distribution with shape and rate normally distributed
# as Normal(3, 0.5) and Normal(2, 0.5) respectively
dist2 <- Gamma(
  shape = Normal(3, 0.5), rate = Normal(2, 0.5), max = 20
)
print(dist2)
}
