% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_workfile.R
\name{import_workfile}
\alias{import_workfile}
\title{Import \code{EViews} equation data members, graph, series and table objects(s) into R, R Markdown or Quarto.}
\usage{
import_workfile(
  wf = "",
  page = "*",
  equation = "*",
  graph = "*",
  series = "*",
  table = "*",
  graph_procs = "",
  save_options = "",
  save_path = dirname(wf),
  save_copy = T,
  class = "df"
)
}
\arguments{
\item{wf}{Object or a character string representing the name of an \code{EViews} workfile.}

\item{page}{Object or a character string representing the name of an \code{EViews} workfile page.}

\item{equation}{Name(s) or wildcard expressions for \code{EViews} equation object(s) in an \code{EViews} workfile}

\item{graph}{Name(s) or wildcard expressions of EViews graph object(S)}

\item{series}{Name(s) of \code{EViews} series object(s) in an \code{EViews} workfile}

\item{table}{Name(s) or wildcard expressions for \code{EViews} table object(s) in an \code{EViews} workfile}

\item{graph_procs}{A vector containing \code{EViews} graph \code{procs} such as \code{datelabel}, \code{align}}

\item{save_options}{A vector of options to be passed to \code{EViews} \code{save} command. It can take values like \code{"t=png"},\code{-c} and so on.}

\item{save_path}{Object or a character string representing the path to the folder to save the \code{EViews} graphs. The current working directory is the default \code{save_path}. Specify the \code{save_path} only if you want the \code{EViews} graphs to live in different path from the current working directory.}

\item{save_copy}{Logical. Whether to save the copy of the graph objects}

\item{class}{Class of the R object: \code{df} for dataframe, or \code{xts} for extendable time-series object.}
}
\value{
An EViews workfile
}
\description{
Use this function to import \code{EViews} equation data members, graph, series and table objects(s) into R, R Markdown or Quarto.
}
\examples{
library(EviewsR)
\dontrun{
demo(exec_commands)

# To import all equation, graph, series and table objects across all pages

import_workfile(wf="exec_commands")

# To import specific objects

import_workfile(wf="exec_commands",equation="ols",graph="x*",series="y*",table="ols*")

# To import objects on specific page(s)

import_workfile(wf="exec_commands",page="eviewspage")


# To access the objects in base R

eviews$eviewspage_ols # equation
# eviewspage-x_graph # graph saved in "figure/" folder
eviews$eviewspage \%>\% head() # series
eviews$eviewspage_olstable  # table

# To get the values above in R Markdown or Quarto:

# chunkLabel$eviewspage_ols # equation
# chunkLabel-eviewspage-x_graph # graph saved in "fig.path" folder
# chunkLabel$eviewspage \%>\% head() # series
# chunkLabel$eviewspage_olstable  # table

}
}
\seealso{
Other important functions: 
\code{\link{EviewsR}},
\code{\link{create_object}()},
\code{\link{eng_eviews}()},
\code{\link{eviews_graph}()},
\code{\link{eviews_import}()},
\code{\link{eviews_pagesave}()},
\code{\link{eviews_wfcreate}()},
\code{\link{eviews_wfsave}()},
\code{\link{exec_commands}()},
\code{\link{export_dataframe}()},
\code{\link{export}()},
\code{\link{import_equation}()},
\code{\link{import_graph}()},
\code{\link{import_kable}()},
\code{\link{import_series}()},
\code{\link{import_table}()},
\code{\link{import}()},
\code{\link{rwalk}()},
\code{\link{set_eviews_path}()}
}
\concept{important functions}
\keyword{documentation}
