% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exactmed.R
\name{exactmed}
\alias{exactmed}
\title{Exact Mediation Effects Computation (Binary Mediator)}
\usage{
exactmed(
  data,
  a,
  m,
  y,
  a1,
  a0,
  m_cov = NULL,
  y_cov = NULL,
  m_cov_cond = NULL,
  y_cov_cond = NULL,
  adjusted = TRUE,
  interaction = TRUE,
  Firth = FALSE,
  boot = FALSE,
  nboot = 1000,
  bootseed = 1991,
  confcoef = 0.95,
  hvalue_m = NULL,
  hvalue_y = NULL,
  yprevalence = NULL
)
}
\arguments{
\item{data}{A named data frame that includes the exposure, mediator and outcome variables as well as the covariates
to be adjusted for in the models. The exposure can be either binary or continuous. If a covariate is categorical,
it has to be included in the data frame as a factor, character or logical variable.}

\item{a}{The name of the binary or continuous exposure variable.}

\item{m}{The name of the binary mediator variable.}

\item{y}{The name of the binary outcome variable.}

\item{a1}{A value corresponding to the high level of the exposure.}

\item{a0}{A value corresponding to the low level of the exposure.}

\item{m_cov}{A vector containing the names of the adjustment variables (covariates) in the mediator model.}

\item{y_cov}{A vector containing the names of the adjustment variables (covariates) in the outcome model.}

\item{m_cov_cond}{A named vector (atomic vector or list) containing specific values for some or all
of the adjustment covariates \code{m_cov} in the mediator model. Please consult the package vignette for details.}

\item{y_cov_cond}{A named vector (atomic vector or list) containing specific values for some or all
of the adjustment covariates \code{y_cov} in the outcome model. Please consult the package vignette for details.}

\item{adjusted}{A logical variable specifying whether to obtain adjusted or unadjusted estimates.
If \code{adjusted = FALSE}, vectors \code{m_cov} and \code{y_cov} are ignored by the procedure.}

\item{interaction}{A logical variable specifying whether there is an exposure-mediator interaction term in the outcome model.}

\item{Firth}{A logical variable specifying whether to compute conventional or penalized maximum likelihood estimates
for the logistic regression models (see details).}

\item{boot}{A logical value specifying whether the confidence intervals are obtained
by the delta method or by percentile bootstrap.}

\item{nboot}{The number of bootstrap replications used to obtain the confidence intervals if \code{boot = TRUE}.
By default \code{nboot = 1000}.}

\item{bootseed}{The value of the initial seed (positive integer) for random number generation if \code{boot = TRUE}.}

\item{confcoef}{A number between 0 and 1 for the confidence coefficient (ex.: 0.95) of the interval estimates.}

\item{hvalue_m}{The value corresponding to the high level of the mediator. If the mediator is already coded
as a numerical binary variable taking 0 or 1 values, then by default \code{hvalue_m = 1}.}

\item{hvalue_y}{The value corresponding to the high level of the outcome. If the outcome is already coded
as a numerical binary variable taking 0 or 1 values, then by default \code{hvalue_y = 1}.}

\item{yprevalence}{The prevalence of the outcome in the population (a number between 0 and 1).
Option used when case-control data are used.
The low level of the outcome is treated as the control level.}
}
\value{
An object of class \code{results} is returned:
\item{ne.or}{Natural effects estimates on OR scale.}
\item{ne.rr}{Natural effects estimates on RR scale.}
\item{ne.rd}{Natural effects estimates on RD scale.}
\item{cdem0}{Controlled direct effect (m=0) estimates.}
\item{cdem1}{Controlled direct effect (m=1) estimates.}
\item{med.reg}{Summary of the mediator regression.}
\item{out.reg}{Summary of the outcome regression.}

If \code{boot==TRUE}, the returned object also contains:

\item{boot.ne.or}{Bootstrap replications of natural effects on OR scale.}
\item{boot.ne.rr}{Bootstrap replications of natural effects on RR scale.}
\item{boot.ne.rd}{Bootstrap replications of natural effects on RD scale.}
\item{boot.cdem0.or}{Bootstrap replications of controlled direct effect (m=0) on OR scale.}
\item{boot.cdem0.rr}{Bootstrap replications of controlled direct effect (m=0) on RR scale.}
\item{boot.cdem0.rd}{Bootstrap replications of controlled direct effect (m=0) on RD scale.}
\item{boot.cdem1.or}{Bootstrap replications of controlled direct effect (m=1) on OR scale.}
\item{boot.cdem1.rr}{Bootstrap replications of controlled direct effect (m=1) on RR scale.}
\item{boot.cdem1.rd}{Bootstrap replications of controlled direct effect (m=1) on RD scale.}
\item{boot.ind}{Indices of the observations sampled in each bootstrap replication (one replication per column).}
}
\description{
Relying on a regression-based approach, the \code{exactmed()} function calculates standard
    causal mediation effects when the outcome and the mediator are binary. More precisely, \code{exactmed()}
    uses a logistic regression specification for both the outcome and the mediator in order to compute \emph{exact}
    conditional natural direct and indirect effects (see details in Samoilenko and Lefebvre, 2021).
    The function returns point and interval estimates for the conditional natural effects without making any assumption
    regarding the rareness or commonness of the outcome (hence the term exact). For completeness, \code{exactmed()} also
    calculates the conditional controlled direct effects at both values of the mediator. Natural and controlled effects
    estimates are reported using three different scales: odds ratio (OR), risk ratio (RR) and risk difference (RD).
    The interval estimates can be obtained either by the delta method or the bootstrap.
}
\details{
By default, \code{exactmed()} reports mediation effects evaluated at the sample-specific mean values of the numerical covariates
    (including the dummy variables created internally by the function to represent the non-reference levels of the categorical covariates).
    In order to estimate mediation effects at specific values of some covariates (that is, stratum-specific effects),
    the user needs to provide named vectors \code{m_cov_cond} and/or \code{y_cov_cond} containing those values or levels. The adjustment
    covariates appearing in both \code{m_cov} and \code{y_cov} (common adjustment covariates) must have the same values; otherwise,
    \code{exactmed()}'s execution is aborted and an error message is displayed in the R console.

    The Firth parameter allows to reduce the bias of the regression coefficients estimators when facing a problem of
    separation or quasi-separation. The bias reduction is achieved by the \code{\link[brglm2]{brglmFit}} fitting method of the \emph{brglm2} package.
    More precisely, estimates are obtained via penalized maximum likelihood with a Jeffreys prior penalty, which is equivalent to the mean
    bias-reducing adjusted score equation approach in Firth (1993).

    When the data come from a case-control study, the \code{yprevalence} parameter should be used and its value ideally correspond to the true outcome prevalence.
    \code{exactmed()} accounts for the ascertainment in the sample by employing weighted regression techniques that use inverse probability weighting (IPW)
    with robust standard errors. These errors are obtained via the \code{\link[sandwich]{vcovHC}} function of the R package \emph{sandwich}.
    Specifically, we use the HC3 type covariance matrix estimator (default type of the \code{\link[sandwich]{vcovHC}} function).

    For the mediation effects expressed on the multiplicative scales (odds ratio, OR; risk ratio, RR), the \code{exactmed()} function
    returns delta method confidence intervals by exponentiating the lower and upper limits of the normal confidence intervals obtained
    for the logarithmic transformations of the effects. The \code{exactmed()} function also provides the estimated standard errors of
    natural and controlled direct effects estimators that are not log-transformed, where those are derived using a first order Taylor expansion
    (e.g., \eqn{\hat{SE}(\hat{OR})=\hat{OR} \times \hat{SE}(\log(\hat{OR}))}). The function performs Z-tests (null hypothesis: there is no effect)
    computing the corresponding two-tailed \emph{p}-values. Note that for the multiplicative scales, the standard scores (test statistics)
    are obtained by dividing the logarithm of an effect estimator by the estimator of the corresponding standard error
    (e.g., \eqn{\log(\hat{OR}) / \hat{SE}(\log(\hat{OR}))}). No log-transformation is applied when working on the risk difference scale.
}
\note{
The \code{exactmed()} function only works for complete data. Users can apply multiple imputation techniques (e.g., R package \emph{mice})
    or remove observations of variables used in mediation analysis that have missing values (NA).
}
\examples{
exactmed(
  data = datamed, a = "X", m = "M", y = "Y", a1 = 1, a0 = 0,
  m_cov = c("C1", "C2"), y_cov = c("C1", "C2")
)

exactmed(
  data = datamed, a = "X", m = "M", y = "Y", a1 = 1, a0 = 0,
  m_cov = c("C1", "C2"), y_cov = c("C1", "C2"), yprevalence = 0.1
)

m_cov_cond <- c(C1 = 0.1, C2 = 0.4)
y_cov_cond <- c(C1 = 0.1, C2 = 0.4)

exactmed(
  data = datamed, a = "X", m = "M", y = "Y", a1 = 1, a0 = 0,
  m_cov = c("C1", "C2"), y_cov = c("C1", "C2"),
  m_cov_cond = m_cov_cond, y_cov_cond = y_cov_cond
)

C1b <- factor(sample(c("a", "b", "c"), nrow(datamed), replace = TRUE))
datamed$C1 <- C1b

m_cov_cond <- list(C1 = "c", C2 = 0.4)
y_cov_cond <- list(C1 = "c", C2 = 0.4)

exactmed(
  data = datamed, a = "X", m = "M", y = "Y", a1 = 1, a0 = 0,
  m_cov = c("C1", "C2"), y_cov = c("C1", "C2"),
  m_cov_cond = m_cov_cond, y_cov_cond = y_cov_cond
)
}
\references{
Samoilenko M, Blais L, Lefebvre G. Comparing logistic and log-binomial models for causal mediation analyses of
binary mediators and rare binary outcomes: evidence to support cross-checking of mediation results in practice.
\emph{Observational Studies}.2018;4(1):193-216. \doi{10.1353/obs.2018.0013}.

Samoilenko M, Lefebvre G. Parametric-regression-based causal mediation analysis of binary outcomes and binary mediators:
moving beyond the rareness or commonness of the outcome. \emph{American Journal of Epidemiology}.2021;190(9):1846-1858. \doi{10.1093/aje/kwab055}.

Samoilenko M, Lefebvre G. An exact regression-based approach for the estimation of the natural direct and indirect effects
with a binary outcome and a continuous mediator. \emph{Statistics in Medicine}.2023; 42(3): 353–387. \doi{10.1002/sim.9621}.

Firth D. Bias reduction of maximum likelihood estimates.
\emph{Biometrika}.1993;80:27-38. \doi{10.2307/2336755}.
}
