% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fat2.ad2.rbd.r
\name{fat2.ad2.rbd}
\alias{fat2.ad2.rbd}
\title{Double factorial scheme plus two additional treatments in RBD}
\usage{
fat2.ad2.rbd(
  factor1,
  factor2,
  block,
  resp,
  respAd1,
  respAd2,
  quali = c(TRUE, TRUE),
  mcomp = "tukey",
  fac.names = c("F1", "F2"),
  sigT = 0.05,
  sigF = 0.05,
  unfold = NULL
)
}
\arguments{
\item{factor1}{Numeric or complex vector containing the
factor 1 levels.}

\item{factor2}{Numeric or complex vector containing the
factor 2 levels.}

\item{block}{Numeric or complex vector containing the blocks.}

\item{resp}{Numeric or complex vector containing the
response variable.}

\item{respAd1}{Numeric or complex vector containing the
additional treatment 1.}

\item{respAd2}{Numeric or complex vector containing the
additional treatment 2.}

\item{quali}{Logic. If TRUE (default), the treatments are
assumed qualitative, if FALSE, quantitatives.}

\item{mcomp}{Allows choosing the multiple comparison test;
the \emph{default} is the test of Tukey, however, the
options are: the LSD test ('lsd'), the LSD test with
Bonferroni protection ('lsdb'), the test of Duncan
('duncan'), the test of Student-Newman-Keuls ('snk'), the
test of Scott-Knott ('sk'), the Calinski and Corsten test
('ccF') and bootstrap multiple comparison's test ('ccboot').}

\item{fac.names}{Allows labeling the factors 1 and 2.}

\item{sigT}{The signficance to be used for the multiple
comparison test; the default is 5\%.}

\item{sigF}{The signficance to be used for the F test of
ANOVA; the default is 5\%.}

\item{unfold}{Says what must be done after the ANOVA.
If NULL (\emph{default}), recommended tests are performed;
if '0', just ANOVA is performed; if '1', the simple effects
are tested; if '2', the double interaction is unfolded.}
}
\value{
The output contains the ANOVA of the referred CRD,
the Shapiro-Wilk normality test for the residuals of the
model, the fitted regression models (when the treatments
are quantitative) and/or the multiple comparison tests
(when the treatments are qualitative).
}
\description{
\code{fat2.ad2.rbd} Analyses experiments in balanced
Randomized Blocks Design in double factorial scheme
with two additional treatments, considering a fixed model.
}
\details{
The arguments sigT and mcomp will be used only when
the treatment are qualitative.
}
\note{
The \code{\link{graphics}} can be used to construct
regression plots and \code{\link{plotres}} for residuals
plots.
}
\examples{
factor1<-c(rep(1,6),rep(2,6))
factor2<-c(rep(1,3),rep(2,3),rep(1,3),rep(2,3))
block<-rep(1:3,4)
resp<-c(10.0,10.8,9.8,10.3,11.3,10.3,9.7,10.1,10.2,9.4,11.6,9.1)
respAd1<-c(10.6,10.6,10.4)
respAd2<-c(5.7,6,7.4)
data.frame(factor1,factor2,block,resp)
fat2.ad2.rbd(factor1, factor2, block, resp, respAd1, respAd2,
quali=c(TRUE, FALSE), mcomp = "tukey", fac.names =
c("XXXX", "YYYY"), sigT = 0.05, sigF = 0.05, unfold=NULL)
}
\references{
???
}
\seealso{
\code{\link{fat2.crd}}, \code{\link{fat2.rbd}},
\code{\link{fat3.crd}}, \code{\link{fat3.rbd}},
\code{\link{fat2.ad.crd}}, \code{\link{fat2.ad.rbd}},
\code{\link{fat3.ad.crd}} and \code{\link{fat3.ad.rbd}}.
}
\author{
Portya Piscitelli Cavalcanti

Sônia Maria De Stefano Piedade

Eric B Ferreira,
\email{eric.ferreira@unifal-mg.edu.br}
}
