% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TPDM.R
\name{wrapper.EPI}
\alias{wrapper.EPI}
\title{Wrapper function}
\usage{
wrapper.EPI(
  X,
  Y = NULL,
  q = 0.98,
  anz_cores = 1,
  clust = NULL,
  m = 1:10,
  thr_EPI = NULL
)
}
\arguments{
\item{X}{A t x n dimensional Data-matrix with t: Number of time steps and n: Number of grid points/stations}

\item{Y}{Optional: Sames as X but for second variable: If Y!=NULL, cross-TPDM instead of TPDM and SVD instead of PCA is computed}

\item{q}{Threshold for computation of TPDM. Only data above the 'q'-quantile will be used for estimation. Choose such that 0 < q < 1.}

\item{anz_cores}{Number of cores for parallel computing (default: 5)}

\item{clust}{Optional_ Uf clust = NULL, no declustering is performed. Else, declustering according to cluster-length 'clust'}

\item{m}{Numeric vector: Containing the principal components/expansion coefficients (in case of Y!=NULL) from which the EPI shall be computed (default: modes = c(1:10), calculates the EPI on first ten principle Components)}

\item{thr_EPI}{Only if Y!=NULL: Threshold for computation of TEPI. Expansion-coefficients that exceed the 'q'-quantile will be used for estimation. Choose such that 0 < q < 1.}
}
\value{
In case of Y =NULL: A list containing:
\itemize{
    \item basis: The Eigenvectors of TPDM
    \item pc: The principal components of TPDM
    \item extremal.basis: The Eigenvectors of TPDM but transformed in positive reals with \link{trans}
    \item EPI: Extremal pattern index
}

In case of Y !=NULL: A list containing:
\itemize{
    \item U, V: The left- and right singular Vectors of cross-TPDM
    \item extr.U, extr.V: The left- and right singular vectors of cross-TPDM, but transformed in positive reals with \link{trans}
    \item pcU, pcV: The left- and right expansion coefficients of cross-TPDM
    \item EPI: Extremal pattern index
    \item TEPI: Threshold-based extremal pattern index
}
}
\description{
Handles all steps for estimation of EPI from raw-data:
1) Preprocessing into Frechet-Margins
2) Estimation of TPDM
3) Calculation of Principal Components
4) Estimation of EPI
}
\examples{
data    <- precipGER
\donttest{
result  <- wrapper.EPI(data$pr, m = 1:50)

rbPal <- colorRampPalette(c('blue', 'white','red'))
Col <- rbPal(10)[as.numeric(cut(result$basis[,2],breaks = 10))]
plot(data$lat, data$lon,col=Col)
plot(data$date, result$EPI, type='l')}
}
\references{
Szemkus & Friederichs 2023
}
