% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FAOPMETo.R
\name{ETo_FPM}
\alias{ETo_FPM}
\title{FAO Penman-Monteith Reference Evapotranspiration (ETo) Equation}
\usage{
ETo_FPM(
  Delta = SlpSVPC(T_mean),
  T_mean = (T_min + T_max)/2,
  R_n = NULL,
  G = 0,
  gamma = PsyCon(AtmPres(elev)),
  u_2 = NULL,
  u_z = NULL,
  z = NULL,
  e_s = MSVP(T_max, T_min),
  T_dew = NULL,
  e_a = NULL,
  T_min = NULL,
  T_max = NULL,
  phi_deg = NULL,
  elev = NULL,
  date = NULL,
  n = NULL,
  N = NULL,
  a_s = 0.25,
  b_s = 0.5
)
}
\arguments{
\item{Delta}{Optional. A numeric scalar that denotes the slope vapour pressure curve [kPa/C].}

\item{T_mean}{Optional. A numeric scalar that denotes the average temperature [C].}

\item{R_n}{Optional. A numeric scalar that denotes the net radiation at the crop surface [\eqn{MJ/(m^2\times day)}].}

\item{G}{Optional. A numeric scalar that denotes the soil heat flux density [\eqn{MJ/(m^2\times day)}]. The default is \code{G=0}.}

\item{gamma}{Optional. A numeric scalar that denotes the psychrometric constant [kPa/C].}

\item{u_2}{A numeric scalar that denotes the wind speed at the height 2m above the ground surface [m/s].}

\item{u_z}{A numeric scalar that denotes the wind speed at the height \code{z} above the ground surface [m/s].}

\item{z}{A numeric scalar that denotes the height above the ground surface where the wind speed has been measured [m].}

\item{e_s}{Optional. A numeric scalar that denotes the saturation vapour pressure [kPa].}

\item{T_dew}{Optional. A numeric scalar that denotes the dew point temperature [C].}

\item{e_a}{Optional. A numeric scalar that denotes the actual vapour pressure [kPa].}

\item{T_min}{Optional. A numeric scalar that denotes the daily minimum temperature [C].}

\item{T_max}{Optional. A numeric scalar that denotes the daily maximum temperature [C].}

\item{phi_deg}{Optional. A numeric scalar that denotes the latitude in terms of degree [degree].}

\item{elev}{Optional. A numeric scalar that denotes the elevation above the sea level [m].}

\item{date}{Optional. A character string that denotes the date in the format "Year-Month-Day" or "Year/Month/Day".}

\item{n}{Optional. A numeric scalar that denotes actual duration of sunshine [hour]}

\item{N}{Optional. A numeric scalar that denotes maximum possible duration of sunshine or daylight hours [hour]}

\item{a_s}{Optional. A numeric scalar that denotes regression constant, expressing the fraction ofextraterrestrial radiation
reaching the earth on overcast days (n = 0). The default is \code{a_s = 0.25}.}

\item{b_s}{Optional. A numeric scalar that denotes fraction of extraterrestrial radiation reaching the earth on clear days
(\eqn{n = N}). The default is \code{b_s = 0.5}}
}
\value{
The function returns the value of evapotranspiration rate from the reference surface as a numeric scalar.
}
\description{
\code{ETo_FPM} returns the value of evapotranspiration rate from the reference surface.
}
\details{
This is a function to calculate the evapotranspiration rate from the reference surface (ETo)
   by using FAO Penman-Monteith equation which is one of the most-widely used equations
   for this purpose. If \code{Delta} is missing, the function uses the argumnet \code{T_mean}
   to compute its value. If \code{T_mean} is missing, the function needs \code{T_min} and \code{T_max}
   to compute \code{T_mean}. If \code{R_n} is missing, the arguments \code{phi_deg}, \code{date},
   \code{n}, \code{N}, \code{elev}, \code{T_min}, \code{T_max}, and \code{e_a} must be present.
   If \code{gamma} is missing, the function needs \code{elev} to compute \code{gamma}.
   If \code{e_s} is missing, the arguments \code{T_min} and \code{T_max} must be present for
   computation of \code{e_s}. If \code{e_a} is missing, one of the arguments \code{T_dew} or 
   \code{T_min} must be present in order to compute \code{e_a}. If \code{T_dew} is missing and \code{T_min}
   is present, then \code{T_dew} is computed based on the \code{T_min} value. If \code{u_2} is missing,
   the function needs the values of the arguments \code{u_z} and \code{z} to compute \code{u_2}.
}
\section{Reference}{

\href{https://www.fao.org/3/x0490E/x0490e00.htm}{Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998).
   \emph{Crop evapotranspiration - Guidelines for computing crop water requirements - FAO Irrigation and drainage paper 56}.
   Fao, Rome, 300(9), D05109.}
}

\examples{
ETo_FPM(u_2 = 2, e_a = 2.85, T_min = 25.6, T_max = 34.8, phi_deg = 13.73,
             elev = 2, date = '2002-04-15', n = 8.5, N = 12.31)

}
\seealso{
\code{\link{ETo_Hrg}} for Hargreaves Equation.
}
