% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_outliers.R
\name{correct_outliers}
\alias{correct_outliers}
\title{Correct Dataset Outliers}
\usage{
correct_outliers(data, r)
}
\arguments{
\item{data}{A numeric matrix or data frame where rows represent observations and
columns represent variables.}

\item{r}{An integer specifying the number of principal components to use for PCA.}
}
\value{
A list containing:
\item{data}{A matrix with corrected data where outliers are replaced by the median of previous values.}
\item{outliers}{A binary matrix (same dimensions as the input data) indicating the position of outliers.}
}
\description{
This function identifies and corrects outliers in a dataset using principal
component analysis (PCA). It scales the data, performs PCA, computes idiosyncratic
components, and replaces values that fall outside a defined outlier threshold with
the median of 5 previous values. The outlier threshold is determined using the
interquartile range (IQR) method.
}
\examples{
data <- matrix(rnorm(100), nrow = 10, ncol = 10)
result <- correct_outliers(data, r = 3)
corrected_data <- result$data
outliers_matrix <- result$outliers

}
