% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window_fava.R
\name{window_list}
\alias{window_list}
\title{Generate sliding windows of specified length given the maximum number of samples}
\usage{
window_list(window_size, length, window_step = 1)
}
\arguments{
\item{window_size}{An integer number specifying the number of samples per window.}

\item{length}{An integer number specifying the total number of samples.}

\item{window_step}{Optional; an integer number specifying the distance between the first entry of adjacent windows. Default is \code{window_step=1}.}
}
\value{
A list of samples of sample indices. Each list entry represents one window.
}
\description{
This function generates a list of of sliding windows conditional on two parameters: the length of each window (number of samples) and the total number of samples present in the data.
}
\examples{
window_list(window_size = 6, length = 40)
window_list(window_size = 6, length = 40, window_step = 2)
}
