% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ot.R
\name{ot_barycenter}
\alias{ot_barycenter}
\title{Compute optimal transport barycenters}
\usage{
ot_barycenter(
  mu,
  costm,
  w = NULL,
  solver = ot_test_lp_solver(),
  constr_mat = NULL
)
}
\arguments{
\item{mu}{matrix (row-wise) or list containing \eqn{K} probability vectors of length \eqn{N}.}

\item{costm}{cost matrix \eqn{c \in \mathbb{R}^{N \times N}}.}

\item{w}{weight vector \eqn{w \in \mathbb{R}_+^K}. The default is \eqn{w = (1 / K, \ldots, 1 / K)}.}

\item{solver}{the LP solver to use, see \code{\link{ot_test_lp_solver}}.}

\item{constr_mat}{the constraint matrix for the underlying LP.}
}
\value{
A list containing the entries \code{cost} and \code{barycenter}.
}
\description{
Compute the optimal transport (OT) barycenter of multiple probability vectors via linear programming.
}
\details{
The OT barycenter is defined as the minimizer of the cost functional,
\deqn{
B_c^w(\mu^1, \ldots, \mu^K) := \min_{\nu} \sum_{k=1}^k w_k \, \mathrm{OT}_c(\mu^k, \nu)\,,
}
where the minimum is taken over all probability vectors \eqn{\nu}.
The OT barycenter is solved via linear programming (LP) and the underlying solver can be controlled
via the parameter \code{solver}.
}
\examples{

K <- 3
N <- 2
costm <- cost_matrix_lp(1:N)
w <- rep(1 / K, K)

# all measures are equal
mu <- matrix(1 / N, K, N, TRUE)

# to run this, a LP solver must be available for ROI (ROI.plugin.glpk by default)
if (requireNamespace("ROI.plugin.glpk")) {
    solver <- ot_test_lp_solver("glpk")
    print(ot_barycenter(mu, costm, w = w, solver = solver))
}

# not all measures are equal
mu[2, ] <- 1:N / sum(1:N)
if (requireNamespace("ROI.plugin.glpk")) {
    solver <- ot_test_lp_solver("glpk")
    print(ot_barycenter(mu, costm, w = w, solver = solver))
}
}
