% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_power.R
\name{average.power.fisher}
\alias{average.power.fisher}
\title{Compute average power of many Fisher's exact tests}
\usage{
average.power.fisher(p1, p2, n, alpha, alternative)
}
\arguments{
\item{p1}{probability in one group (vector)}

\item{p2}{probability in other group (vector)}

\item{n}{per-group sample size}

\item{alpha}{p-value threshold}

\item{alternative}{one- or two-sided test}
}
\value{
Average power estimate for multiple testing procedure
}
\description{
Compute average power of many Fisher's exact tests
}
\examples{
set.seed(1234);
p1 = sample(seq(0,0.5,0.1),5,replace = TRUE);
p2 = sample(seq(0.5,1,0.1),5,replace = TRUE);
average.power.fisher(p1 = p1,p2 = p2,n = 20,alpha = 0.05,alternative = "two.sided")
}
\seealso{
\code{\link{power.fisher}} for more details about power calculation of Fisher's exact test
}
