% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k_kienerES.R
\name{ckiener1234}
\alias{ckiener1234}
\alias{hkiener1}
\alias{hkiener2}
\alias{hkiener3}
\alias{hkiener4}
\alias{hkiener7}
\alias{ckiener1}
\alias{ckiener2}
\alias{ckiener3}
\alias{ckiener4}
\alias{ckiener7}
\title{Quantile (VaR) and Expected Shortfall Corrective Functions}
\usage{
hkiener1(p, m = 0, g = 1, k = 3.2, lower.tail = TRUE, log.p = FALSE)

hkiener2(p, m = 0, g = 1, a = 3.2, w = 3.2, lower.tail = TRUE,
  log.p = FALSE)

hkiener3(p, m = 0, g = 1, k = 3.2, d = 0, lower.tail = TRUE,
  log.p = FALSE)

hkiener4(p, m = 0, g = 1, k = 3.2, e = 0, lower.tail = TRUE,
  log.p = FALSE)

hkiener7(p, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), lower.tail = TRUE,
  log.p = FALSE)

ckiener1(p, k = 3.2, lower.tail = TRUE, log.p = FALSE)

ckiener2(p, a = 3.2, w = 3.2, lower.tail = TRUE, log.p = FALSE)

ckiener3(p, k = 3.2, d = 0, lower.tail = TRUE, log.p = FALSE)

ckiener4(p, k = 3.2, e = 0, lower.tail = TRUE, log.p = FALSE)

ckiener7(p, coefk = c(0, 1, 3.2, 3.2, 3.2, 0, 0), lower.tail = TRUE,
  log.p = FALSE)
}
\arguments{
\item{p}{numeric or vector of probabilities.}

\item{m}{numeric. parameter m used in model K1, K2, K3 and K4.}

\item{g}{numeric. parameter g used in model K1, K2, K3 and K4.}

\item{k}{numeric. parameter k used in model K1, K3 and K4.}

\item{lower.tail}{logical. If TRUE, use p. If FALSE, use 1-p.}

\item{log.p}{logical. If TRUE, probabilities p are given as log(p).}

\item{a}{numeric. parameter a used in model K2.}

\item{w}{numeric. parameter w used in model K2.}

\item{d}{numeric. parameter d used in model K3.}

\item{e}{numeric. parameter e used in model K4.}

\item{coefk}{vector or 7 columns-matrix representing parameters 
\code{c(m,g,a,k,w,d,e)} obtained from \code{\link{paramkienerX}}.}
}
\description{
Quantile functions (or VaR) and Expected Shortfall of Kiener distributions 
K1, K2, K3 and K4, usually calculated at pprobs2 = c(0.01, 0.025, 0.05, 0.95, 0.975, 0.99), 
can be expressed as: 
\enumerate{
  \item Quantile of the logit function multiplied by a fat tail 
        (c)orrective function \code{ckiener1234};
  \item Expected s(h)ortfall of the logistic function multiplied 
        by a corrective function \code{hkiener1234}. 
}
Both functions \code{ckiener1234} and \code{hkiener1234} are independant from 
the scale parameter \code{g} and are indirect measures of the tail curvature. 
A value close to \code{1} indicates a model similar to the logistic function with  
almost no curvature and probably parameter \code{k > 8}. When \code{k} (or \code{a,w}) 
decreases, the values of \code{c} and \code{h} increase and indicate some more 
pronounced symmetric or asymmetric curvature, depending on values of \code{d,e}. 
Note that if \code{(min(a,k,w) <= 1)}, \code{ckiener1234} still exists but 
the expected shortfall and \code{hkiener1234} become undefined (\code{NA}).

Some financial applications use threshold values on \code{ckiener1234} or 
\code{hkiener1234} to select or discard stocks over time as they become 
less or more risky.
}
\seealso{
\code{\link{logit}}, \code{\link{qkiener1}}, \code{\link{qkiener2}}, 
\code{\link{qkiener3}}, \code{\link{qkiener4}}, \code{\link{fitkienerX}}.
}
