% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_yield_table.R
\name{fe_yield_table}
\alias{fe_yield_table}
\title{User Friendly Construction of an \strong{fe_yield_table} Object from a Data Frame}
\usage{
fe_yield_table(
  x,
  name_orig,
  name_int,
  si_variable = "h_q_m",
  mai_variable = NA
)
}
\arguments{
\item{x}{Data frame to become an \code{fe_yield_table} object. The minimum
required columns (all numeric) and their names are:

\itemize{
\item{age: Stand age in years}
\item{si: Site index following the yield table's definition}
\item{ba_m2_ha: The stand's standing basal area in m²/ha}
\item{v_m3_ha: The stand's standing volume in m³/ha}
\item{pai_m3_ha_yr: The periodic annual volume increment in m³/ha/yr}
\item{mai_m3_ha_yr: The mean annual volume increment in m³/ha/yr}
}

The variable(s) named as the input parameters \code{si_variable} and
\code{mai_variable} must be present in addition. NA values are allowed.
All other columns of \code{x} will also be taken into the yield table
object and will be accessible by all functions that request values from
yield tables.}

\item{name_orig}{Name of the table in the language it was originally
published}

\item{name_int}{Internatonalized (i.e. English) version of the table name}

\item{si_variable}{Character (vector), name(s) of the variable(s) (i.e.
column(s) in x) which is/are used for site indexing. Usually, this will be
stand heights. Some yield tables contain different definitions of stand
heights (e.g. mean and dominant height). In order to enable site indexing
by more than one height definition in such a case, more than one variable
name can be provided here. At least one site index variable must be given
to obtain a valid fe_yield_table object.}

\item{mai_variable}{Character (vector), name(s) of the variable(s) (i.e.
column(s) in x) which can be used for mai-site indexing. Clearly, this will
be variables containing a mean annual increment (mai). Some yield tables
contain different definitions of mai (e.g. over- and under bark).
Therefore, more than one variable name can be provided here. If no mai
variable is provided (\code{mai_variable = NA}, default), mai site indexing
is not possible with the yield table of interest.}
}
\value{
An object of class \code{fe_yield_table}, if the input allows to
build a valid one. If this is not the case, the function will terminate
with an error.
}
\description{
User Friendly Construction of an \strong{fe_yield_table} Object from a Data Frame
}
\examples{
  # Make fe_yield_table object from a very original-table-like data frame
  ytable_pine_wiedemann_moderate_1943_raw |>
    fe_yield_table(
      name_orig = "Kiefer Wiedemann 1943 Maessige Durchforstung",
      name_int  = "Scots Pine Wiedemann 1943 Moderate Thinning",
      si_variable = "h_q_m",
      mai_variable = c("mai_m3_ha_yr", "red_mai_m3_ha_yr")
    )

}
\seealso{
Other yield table functions: 
\code{\link{plot.fe_yield_table}()},
\code{\link{si_to_mai_age}()},
\code{\link{si_to_mai_max}()},
\code{\link{site_index}()},
\code{\link{stocking_level}()},
\code{\link{yield_tables_for_species}},
\code{\link{ytable_age_slice}()},
\code{\link{ytable_lookup}()},
\code{\link{ytable_max_slice}()}
}
\concept{yield table functions}
