% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simulated_data}
\alias{simulated_data}
\title{Simulated Data}
\format{
An object of class \code{list} of length 4.
}
\usage{
simulated_data
}
\value{
\describe{
  \item{\code{data}}{A data frame with 1024 rows and 100 columns. \cr
                         Each column represents one sample of the aggregated functions with Gaussian noise \eqn{N(0, 0.1)}.}
  \item{\code{weigths}}{A data frame with 2 rows and 100 columns. \cr
                               Each column contains the random concentrations used to aggregate the two functions in each sample.}
  \item{\code{x}}{A numeric vector of length 1024. \cr
                  The grid of x-values used in the simulation, equally spaced from -1 to 2.}
  \item{\code{alphas}}{A data frame with 1024 rows and 2 columns. \cr
                           The true values of the functions \eqn{\alpha_1(x)} and \eqn{\alpha_2(x)} evaluated over the x grid.}
}
}
\description{
This is a simulated dataset designed to illustrate the functionalities of the package.
It contains 100 samples of aggregated data generated from two functions, \eqn{\alpha_1(x)} and \eqn{\alpha_2(x)}, with added Gaussian noise \eqn{N(0, 0.1)}.

The functions used in the simulation are:

\deqn{\alpha_1(x) = \sin(5x) e^{-x^2} \quad \alpha_2(x) = \begin{cases} -2, & x < 0 \\ 0, & 0 \leq x < 1.5 \\ 3, & x \geq 1.5 \end{cases}}

The simulations were performed over an equally spaced grid of 1024 points in the interval [-1, 2].
These functions were linearly combined using random concentrations to generate the samples, with the addition of Gaussian noise.
}
\keyword{datasets}
