% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-special_functions.R
\docType{methods}
\name{^,PiecewiseLinearFuzzyNumber,numeric-method}
\alias{^,PiecewiseLinearFuzzyNumber,numeric-method}
\title{Integer power of fuzzy number}
\usage{
\S4method{^}{PiecewiseLinearFuzzyNumber,numeric}(e1, e2)
}
\arguments{
\item{e1}{a PiecewiseLinearFuzzyNumber}

\item{e2}{numeric (if it is not integer it will be converted by function
as.integer())}
}
\value{
Returns a fuzzy number of the class \linkS4class{PiecewiseLinearFuzzyNumber}
indicating \code{e1^e2}.
}
\description{
For fuzzy numbers the equality of \code{X*X == X^2} does not hold.
}
\details{
This function calculates integer power of a PiecewiseLinearFuzzyNumber according
to the reference below.
}
\examples{
x = as.PiecewiseLinearFuzzyNumber(TriangularFuzzyNumber(-2, 1, 9), knot.n = 2)
x^2
x^3
}
\references{
KAUFMANN, A., GUPTA, M. M. (1985) Introduction to Fuzzy Arithmetic. 
New York : Van Nostrand Reinhold Company. ISBN 044230079.
}
\seealso{
Other extension_principle: 
\code{\link{Arithmetic}},
\code{\link{fapply}()}

Other PiecewiseLinearFuzzyNumber-method: 
\code{\link{Arithmetic}},
\code{\link{Extract}},
\code{\link{PiecewiseLinearFuzzyNumber-class}},
\code{\link{PiecewiseLinearFuzzyNumber}},
\code{\link{alphaInterval}()},
\code{\link{arctan2}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{expectedInterval}()},
\code{\link{fapply}()},
\code{\link{maximum}()},
\code{\link{minimum}()},
\code{\link{necessityExceedance}()},
\code{\link{necessityStrictExceedance}()},
\code{\link{necessityStrictUndervaluation}()},
\code{\link{necessityUndervaluation}()},
\code{\link{plot}()},
\code{\link{possibilityExceedance}()},
\code{\link{possibilityStrictExceedance}()},
\code{\link{possibilityStrictUndervaluation}()},
\code{\link{possibilityUndervaluation}()}
}
\concept{PiecewiseLinearFuzzyNumber-method}
\concept{extension_principle}
