#' @export
#' @keywords internal
AIC.GARCHX <- function(model){
  # Calculate initial value for sigma^2
  #sigma.init <- mean(model$eps[1:model$r]^2)
  sigma.init <- mean(model$eps[1:model$r]^model$delta)

  # Calculate epsilon^delta
  eps.delta <- model$eps^model$delta

  # Check if model is GARCHX or GARCH
  if(is.na(model$pi[1])){
    null = TRUE
  } else {
    null = FALSE
  } # End if-else

  # Calculate QMLE using likelihood
  # QMLE <- Likelihood(model, sigma.init = sigma.init, length(model$eps),
  #                    eps.delta = eps.delta, null)
  # Do we need to use nlminb here?

  p <- model$order[1]
  q <- model$order[2]
  # Using likelihood, calculate AIC value
  AIC <- 2 * length(model$eps) * model$Likelihood + (1 + p + q + model$d) * 2

  # Return AIC value
  return(AIC)
} # End AIC.GARCHX
