% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/between_trial_change.R
\name{between_trial_change}
\alias{between_trial_change}
\title{Compare mean activity between trials}
\usage{
between_trial_change(Dataframe, TrialRange1, TrialRange2,
  Time.period = c(min(Dataframe[1]), max(Dataframe[1])))
}
\arguments{
\item{Dataframe}{a GCaMP-format data frame or matrix}

\item{TrialRange1}{range of trial numbers to be compared to second set of trials}

\item{TrialRange2}{range of trial numbers to be compared to first set of trials}

\item{Time.period}{range of time to be compared between sets of trials}
}
\value{
Number representing mean difference of trial set 2 and trial set 1
}
\description{
`between_trial_change` finds the difference in means during same time range between sets of trials.
}
\examples{
# How much did the mean value change 2s after epoc between trials 1-5 and trials 6-10?
df.new <- format_data(data = GCaMP)
between_trial_change(Dataframe = df.new, TrialRange1 = c(1, 5),
TrialRange2 = c(6, 10), Time.period = c(0, 2))
}
