% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centered_AUC.R
\name{centered_AUC}
\alias{centered_AUC}
\title{Compute centered area under curve}
\usage{
centered_AUC(Dataframe, Trial, FUN = mean)
}
\arguments{
\item{Dataframe}{a GCalcium-format data frame or matrix}

\item{Trial}{a single trial number}

\item{FUN}{a function to apply to each window}
}
\value{
Data frame of AUCs and curve number for each curve
}
\description{
`centered_AUC` computes the area under the curve (AUC) after centering values using a specified function, such as mean or min. Computed using trapezoidal integration.
}
\examples{
# Get AUCs for trial 2, centered at the mean
df.new <- format_data(data = GCaMP)
centered_AUC(Dataframe = df.new, Trial = 2, FUN = mean)
}
