% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_GNSS.R
\name{plot_GNSS}
\alias{plot_GNSS}
\title{Graph of the result}
\usage{
plot_GNSS(Data, segmentation, functional)
}
\arguments{
\item{Data}{a data frame, with size [n x 2], containing the signal (e.g. the daily GPS-ERAI series for GNSS) and the dates (in format yyyy-mm-dd of type "calendar time" (class POSIXct))}

\item{segmentation}{the estimated segmentation (result of the GNSSseg function)}

\item{functional}{the estimated functional (result of the GNSSseg function)}
}
\value{
a plot of the results with the signal
}
\description{
plot the signal with the estimated average
}
\details{
The function gives the plot of the results with the signal
}
\examples{
data(Data)
lyear=365.25
Kmax=4
lmin=1
result=GNSSseg(Data,lyear,selection.K="none",Kmax=Kmax)
plot_GNSS(Data,result$seg,result$funct)
}
