% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeneGotermAndLevelOL.R
\name{Gene2GOTermAndLevel}
\alias{Gene2GOTermAndLevel}
\title{Get the Gene Ontology (GO) terms associated with a gene(s) and their levels}
\usage{
Gene2GOTermAndLevel(genes, organism, domain = NULL)
}
\arguments{
\item{genes}{A character vector of entrezgene id's belonging to an organism of interest}

\item{organism}{An object of class character. A character string that defines the scientific / common name of the organism  eg.
Homo sapiens, Mouse.}

\item{domain}{An optional object of class character. GO-terms have three domains .i.e. biological process (BP),
molecular function (MF) and cellular component (CC). This character string identifies which of the three GO
categories associated with the genes to return. GO-terms from one domain can be returned at a time.
If NULL the biological process GO-terms will be obtained (default).}
}
\value{
A data.frame object that contains the genes, GO terms, ontology and GO-levels
}
\description{
Retrieves the gene association GO-terms, also, the ontology of the terms as
             well as the respective levels based on the directed acyclic graph (DAG)
             are returned. The supported organisms are "Homo sapiens / Human",
             "Rattus norvegicus / Rat", "Mus musculus / Mouse", "Danio rerio / Zebrafish", "Caenorhabditis elegans / Worm",
             "Arabidopsis thaliana / cress", "Saccharomyces cerevisiae / Yeast",
             "Schizosaccharomyces pombe / Fission yeast", "Drosophila melanogaster / Fruit fly", "Escherichia coli / E.coli".
}
\note{
This function is similar to \code{\link{Gene2GOTermAndLevel_ON}}, the difference is that the function do not query the
Ensembl database for GO terms (It is relatively faster) which means the results from Gene2GOTermAndLevel_ON function is always up to date.
}
\examples{
 # human genes
v <- c(6713,4605,55143,10615,10212,4001,2146,11130,983,4085,9833,9134)

# No value for domain is given so the default ("BP") is used
Gene2GOTermAndLevel(genes = v, organism = "Homo sapiens")

# The scientific names of the species can also be used
Gene2GOTermAndLevel(genes = v, organism = "Homo sapiens", domain = "CC")

Gene2GOTermAndLevel(genes = v, organism = "Human", domain = "MF")

}
