% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.gene.lsn.overlaps.R
\name{find.gene.lsn.overlaps}
\alias{find.gene.lsn.overlaps}
\title{Find Gene Lesion Overlaps}
\usage{
find.gene.lsn.overlaps(gl.data)
}
\arguments{
\item{gl.data}{A list of five \code{data.frame} objects returned by the \code{prep.gene.lsn.data()} function.
These include processed and indexed gene and lesion data ready for overlap analysis.}
}
\value{
A list containing the following components:
\item{lsn.data}{Original input lesion data.}
\item{gene.data}{Original input gene annotation data.}
\item{gene.lsn.data}{A \code{data.frame} ordered by chromosome and start position, containing both gene and lesion entries.
Each row includes a \code{cty} code indicating the type and boundary of the interval:
1 = gene start, 2 = lesion start, 3 = lesion end, 4 = gene end.}
\item{gene.lsn.hits}{A \code{data.frame} where each row corresponds to a gene overlapped by a lesion.
Includes 11 columns:
\code{"gene"} (Ensembl gene ID),
\code{"gene.chrom"}, \code{"gene.loc.start"}, \code{"gene.loc.end"} (chromosome and coordinates of the gene),
\code{"ID"} (patient/sample ID),
\code{"lsn.chrom"}, \code{"lsn.loc.start"}, \code{"lsn.loc.end"} (chromosome and coordinates of the lesion),
and \code{"lsn.type"} (type of lesion).}
\item{gene.index}{A \code{data.frame} indexing the rows in \code{gene.lsn.data} that correspond to each chromosome's genes (row start and row end per chromosome).}
\item{lsn.index}{A \code{data.frame} indexing the rows in \code{gene.lsn.data} that correspond to each lesion (row start and row end per lesion).}
}
\description{
Identifies overlaps between genes and genomic lesions using the output from the \code{prep.gene.lsn.data()} function.
This function detects all instances where a lesion spans or intersects the genomic coordinates of a gene.
}
\examples{
data(lesion_data)
data(hg38_gene_annotation)

# Prepare gene and lesion data for GRIN-based computations:
prep.gene.lsn <- prep.gene.lsn.data(lesion_data, hg38_gene_annotation)

# Identify genes that are overlapped by lesions:
gene.lsn.overlap <- find.gene.lsn.overlaps(prep.gene.lsn)
}
\references{
Pounds, S. et al. (2013). A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link{prep.gene.lsn.data}}
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org}, Stanley Pounds \email{stanley.pounds@stjude.org}
}
