% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_grm.r
\name{runGRM}
\alias{runGRM}
\title{Run graded response model}
\usage{
runGRM(dat, lav.syntax, estimator)
}
\arguments{
\item{dat}{a data frame containing graded response model data}

\item{lav.syntax}{a character indicating \pkg{lavaan} syntax}

\item{estimator}{a character indicating the type of estimator.
\itemize{
  \item \code{"ML"} Maximum likelihood estimation.
  \item \code{"WL"} Weighted least squares mean and variance (WLSMV).
}}
}
\value{
a list containing GRM results as follows:
\describe{
  \item{\code{fit}}{An object of class
    \link[mirt:SingleGroupClass-class]{SingleGroupClass} (from \pkg{mirt})
    or \link[lavaan:lavaan-class]{lavaan} (from \pkg{lavaan}).}
  \item{\code{grm.par}}{A data frame containing graded response parameters.}
}
}
\description{
Run graded response model
}
\details{
This conducts GRM. The second element of the return indicates
the graded response parameters converted from the CFA parameters
}
