% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{full_data}
\alias{full_data}
\title{Gene expression matrix}
\format{
Gene expression matrix with  4165 rows and 121 columns.
\describe{The columns correspond to the patients and the rows to
the genes. The column names correspond to the patient identifier
in GEO. The row names correspond to the gene names.
}
}
\source{
The data are from the study GSE42568 available in
\url{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE42568}.
The data were processed as explained in the \code{details} section.
}
\usage{
data(full_data, package = "GSSTDA")
}
\description{
Matrix containing gene expression profiling of 104 breast cancer and
17 normal breast biopsies. Expression profiling data by array
(platform HG-U133_Plus_2).
}
\details{
Normalized gene expression data GSE42568. Background correction,
summarization, and quantile normalization were carried out using the
fRMA method implemented in the \code{fRMA} package. Filtered probes that did
not target genes with valid gene id were filtered and  those probes
targeting the same gene were collapse by thanking those presenting the
highest row variance using the \code{WGCNA::collapseRows} function.
Subsequently, due to CRAN publication requirements, the number of genes
is randomly reduced to 4165 genes.
}
\keyword{datasets}
