% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods_GeDSboost-GeDSgam.R
\name{coef.GeDSgam,boost}
\alias{coef.GeDSgam,boost}
\alias{coef.GeDSgam}
\alias{coef.GeDSgam,}
\alias{coef.GeDSboost}
\title{Coef Method for GeDSgam, GeDSboost}
\usage{
\method{coef}{GeDSgam}(object, n = 3L, ...)

\method{coef}{GeDSboost}(object, n = 3L, ...)
}
\arguments{
\item{object}{The \code{"GeDSgam"} class or
\code{"GeDSboost"} class object from which the coefficients should be
extracted.}

\item{n}{Integer value (2, 3 or 4) specifying the order (\eqn{=} degree
\eqn{ + 1}) of the FGB-GeDS/GAM-GeDS fit whose coefficients should be
extracted. 
\itemize{
 \item If \code{n = 2L}: the piecewise polynomial coefficients of the univariate
 GeDS base-learners and linear base-learners are provided (the B-spline coefficients
 are accessible through \code{x$final_model$linear.fit$theta}); for bivariate GeDS
 base-learners and \code{class(object) == "GeDSboost"}, the B-spline coefficients
 for each iteration where the corresponding bivariate base-learner was selected are
 provided; for bivariate base-learners and \code{class(object) == "GeDSgam"},
 the final local-scoring B-spline coefficients are provided.
  \item If \code{n = 3L} or \code{n = 4L}: B-spline coefficients are provided
 for both univariate and bivariate GeDS learners.
}
By default \code{n} is equal to \code{3L}. Non-integer values will be passed
to the function \code{\link{as.integer}}.}

\item{...}{Potentially further arguments (required by the definition of the
generic function). These will be ignored, but with a warning.}
}
\value{
A named vector containing the required coefficients of the fitted
multivariate predictor model.
}
\description{
Method for the function \code{\link[stats]{coef}} that allows to extract the
estimated coefficients of a \code{"GeDSgam"} class or \code{"GeDSboost"} class
object.
}
\examples{
data(mtcars)
# Convert specified variables to factors
categorical_vars <- c("cyl", "vs", "am", "gear", "carb")
mtcars[categorical_vars] <- lapply(mtcars[categorical_vars], factor)

Gmodgam <- NGeDSgam(mpg ~ f(disp, hp) + f(qsec) + carb,
                    data = mtcars, family = gaussian, phi = 0.7)

# Piecewise polynomial coefficients of the (univariate) GeDS and linear learners
coef(Gmodgam, n = 2)$`f(qsec)`
coef(Gmodgam, n = 2)$carb
# B-spline coefficients of the bivariate learner
coef(Gmodgam, n = 2)$`f(disp, hp)`

Gmodboost <- NGeDSboost(mpg ~ f(disp, hp) + f(qsec) + carb,
                        data = mtcars, family = mboost::Gaussian(), shrinkage = 0.7)

# Piecewise polynomial coefficients of the (univariate) GeDS and linear learners
coef(Gmodboost, n = 2)$`f(qsec)`
coef(Gmodboost, n = 2)$carb
# B-spline coefficients of the bivariate learner at each boosting iteration
# this was selected
coef(Gmodboost, n = 2)$`f(disp, hp)`

}
\seealso{
\code{\link[stats]{coef}} for the standard definition;
\code{\link{NGeDSgam}} and \code{\link{NGeDSboost}} for examples.
}
