% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods.R
\name{coef.GeDS}
\alias{coef.GeDS}
\title{Coef Method for GeDS Objects}
\usage{
\method{coef}{GeDS}(object, n = 3L, onlySpline = TRUE, ...)
}
\arguments{
\item{object}{The  \code{"GeDS"} class object from which the
coefficients of the selected GeDS regression model should be extracted.}

\item{n}{Integer value (2, 3 or 4) specifying the order (\eqn{=} degree
\eqn{+ 1}) of the \code{"GeDS"}, \code{"GeDSgam"} or \code{"GeDSboost"}
fit whose coefficients should be extracted. By default equal to \code{3L};
non-integer values will be passed to the function \code{\link{as.integer}}.}

\item{onlySpline}{Logical variable specifying whether only the coefficients
for the GeDS  component of a fitted multivariate regression model should be
extracted or whether the coefficients of both the GeDS and the parametric
components should be returned.}

\item{...}{Potentially further arguments (required by the definition of the
generic function). These will be ignored, but with a warning.}
}
\value{
A named vector containing the required coefficients of the fitted
univariate or multivariate predictor model. The coefficients corresponding to
the variables that enter the parametric component of the fitted multivariate
predictor model are named as the variables themselves. The  coefficients of
the GeDS component are coded as "\code{N}" followed by the index of the
corresponding B-spline.
}
\description{
Method for the function \code{\link[stats]{coef}} that allows to extract the
estimated coefficients of a fitted GeDS regression model from a \code{"GeDS"} class
object.
}
\details{
Simple method for the function \code{\link[stats]{coef}}.

As \code{"GeDS"} class objects contain three different fits (linear,
quadratic and cubic), the argument \code{n} can be used to specify the order
of the GeDS fit for which regression coefficients are required.

As mentioned in the Details of \code{\link[=formula.GeDS]{formula}}, the
predictor model may be multivariate and it may include a (univariate or
bivariate) GeD spline component, plus a parametric component involving the
remaining variables. If the \code{onlySpline} argument is set to
\code{TRUE} (the default value), only the coefficients corresponding to the
GeD spline component of order \code{n} of the multivariate predictor model 
are extracted.
}
\examples{
# Generate a data sample for the response variable
# and the covariates
set.seed(123)
N <- 500
f_1 <- function(x) (10*x/(1+100*x^2))*4+4
X <- sort(runif(N ,min = -2, max = 2))
Z <- runif(N)
# Specify a model for the mean of the response Y to be a superposition of
# a non-linear component f_1(X), a linear component 2*Z and a
# free term 1, i.e.
means <- f_1(X) + 2*Z + 1
# Add normal noise to the mean of Y
Y <- rnorm(N, means, sd = 0.1)

# Fit to this sample a predictor model of the form f(X) + Z, where
# f(X) is the GeDS component and Z is the linear (additive) component
# see ?formula.GeDS for details
(Gmod <- NGeDS(Y ~ f(X) + Z, beta = 0.6, phi = 0.995, Xextr = c(-2,2)))

# Extract the GeD spline regression coefficients
coef(Gmod, n = 3)

# Extract all the coefficients, including the one for the linear component
coef(Gmod, onlySpline = FALSE, n = 3)

}
\seealso{
\code{\link[stats]{coef}} for the standard definition;
\code{\link{NGeDS}} for more examples.
}
