% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carcass_persistence_functions.R
\name{aicc.cpmSetSize}
\alias{aicc.cpmSetSize}
\title{Create the AICc tables for a list of sets of searcher efficiency models}
\usage{
\method{aicc}{cpmSetSize}(x, ...)
}
\arguments{
\item{x}{List of sets of CP models fit to the same observations}

\item{...}{further arguments passed to or from other methods}
}
\value{
AICc table
}
\description{
S3 function to generate model comparison tables for lists of
 of sets of CP models of class \code{\link[=cpm]{cpmSetSize}}
}
\examples{
 cpmods <- cpm(formula_l = l ~ Visibility, data = wind_RP$CP,
   left = "LastPresent", right = "FirstAbsent", sizeCol = "Size",
   allCombos = TRUE)
 aicc(cpmods)

}
