% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection_probability_functions.R
\name{averageSS}
\alias{averageSS}
\title{Tabulate an average search schedule from a multi-unit SS data table}
\usage{
averageSS(data_SS, SSdate = NULL)
}
\arguments{
\item{data_SS}{a multi-unit SS data table, for which the average interval 
will be tabulated. It is assumed that \code{data_SS} is properly 
formatted, with a column of search dates and a column of 1s and 0s for 
each unit indicating whether the unit was searched on the given date).
Other columns are optional, but optional columns should not all contain
at least on value that is not a 1 or 0.}

\item{SSdate}{Column name for the date searched data (optional).
if no \code{SSdate} is provided, \code{data_SS} will be parsed
to extract the dates automatically. If there is more than one column with
dates, then an error will be thrown and the user will be required to
provide the name of the desired dates column.}
}
\value{
vector of the average search schedule
}
\description{
Given a multi-unit Search Schedule data table, produce an 
  average search schedule for use in generic detection probability 
  estimation.
}
\examples{
  data(mock)
  avgSS <- averageSS(mock$SS)

}
