% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configure_environment.R
\name{set_reticulate_python}
\alias{set_reticulate_python}
\title{Set RETICULATE_PYTHON for the Current Session}
\usage{
set_reticulate_python(env_name = "GeneSelectR_env")
}
\arguments{
\item{env_name}{The name of the Conda environment. Default is 'GeneSelectR_env'.}
}
\value{
This function does not return a value. Instead, it sets the RETICULATE_PYTHON environment variable for the
current R session and prints a message indicating the new value of RETICULATE_PYTHON. If the specified
environment does not exist, the function stops with an error message.
}
\description{
This function sets the RETICULATE_PYTHON environment variable to the path of the Python interpreter
in the specified Conda environment, but only for the current R session. The change will not persist
after the R session is closed.
}
\details{
This function checks if the specified Conda environment exists. If it does, the function sets the
RETICULATE_PYTHON environment variable to the path of the Python interpreter in that environment.
If the environment does not exist, the function stops with an error message.

Users need to run this function in every new R session where they want to use your package. Also,
they should run this function before loading your package with library(), because the RETICULATE_PYTHON
environment variable needs to be set before reticulate is loaded.
}
\examples{
\donttest{
set_reticulate_python('GeneSelectR_env')
}
}
